/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayDeque;
import java.util.Random;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.worldgen.WorldGenConfiguration;
import mcjty.deepresonance.worldgen.WorldTickHandler;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.apache.commons.lang3.tuple.Pair;

public class DeepWorldGenerator
implements IWorldGenerator {
    public static final String RETRO_NAME = "DeepResGen";
    public static DeepWorldGenerator instance = new DeepWorldGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!newGen && !WorldGenConfiguration.retrogen) {
            return;
        }
        this.addOreSpawn(ModBlocks.resonatingOreBlock, (byte)0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, WorldGenConfiguration.minVeinSize, WorldGenConfiguration.maxVeinSize, WorldGenConfiguration.chancesToSpawn, WorldGenConfiguration.minY, WorldGenConfiguration.maxY);
        if (WorldGenConfiguration.crystalSpawnChance > 0 && random.nextInt(WorldGenConfiguration.crystalSpawnChance) == 0) {
            this.attemptSpawnCrystal(random, chunkX, chunkZ, world);
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    private void attemptSpawnCrystal(Random random, int chunkX, int chunkZ, World world) {
        for (int i = 0; i < WorldGenConfiguration.crystalSpawnTries; ++i) {
            int y;
            int x = chunkX * 16 + random.nextInt(16);
            int z = chunkZ * 16 + random.nextInt(16);
            boolean air = false;
            for (y = world.func_72825_h(x, z) - 1; y > 1 && !air; --y) {
                if (!world.func_147437_c(x, y, z)) continue;
                air = true;
            }
            if (!air) continue;
            while (y > 1 && air) {
                if (!world.func_147437_c(x, y, z)) {
                    air = false;
                    continue;
                }
                --y;
            }
            if (air || world.func_147439_a(x, y, z) != Blocks.field_150348_b) continue;
            if (WorldGenConfiguration.verboseSpawn) {
                Logging.log((String)("Spawned a crystal at: " + x + "," + y + "," + z));
            }
            ResonatingCrystalTileEntity.spawnRandomCrystal(world, random, x, y + 1, z, 0);
            return;
        }
    }

    public void addOreSpawn(Block block, byte blockMeta, Block targetBlock, World world, Random random, int blockXPos, int blockZPos, int minVeinSize, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        WorldGenMinable minable = new WorldGenMinable(block, (int)blockMeta, minVeinSize - random.nextInt(maxVeinSize - minVeinSize), targetBlock);
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            minable.func_76484_a(world, random, posX, posY, posZ);
        }
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound genTag = event.getData().func_74775_l(RETRO_NAME);
        if (!genTag.func_74764_b("generated")) {
            genTag.func_74757_a("generated", true);
        }
        event.getData().func_74782_a(RETRO_NAME, (NBTBase)genTag);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.world.field_73011_w.field_76574_g;
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a(RETRO_NAME);
        NBTTagList list = null;
        Pair cCoord = Pair.of((Object)event.getChunk().field_76635_g, (Object)event.getChunk().field_76647_h);
        if (tag != null) {
            boolean generated;
            boolean bl = generated = WorldGenConfiguration.retrogen && !tag.func_74764_b("generated");
            if (generated) {
                Logging.log((String)("Queuing Retrogen for chunk: " + cCoord.toString() + "."));
                regen = true;
            }
        } else {
            regen = WorldGenConfiguration.retrogen;
        }
        if (regen) {
            ArrayDeque chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            if (chunks == null) {
                WorldTickHandler.chunksToGen.put(dim, new ArrayDeque(128));
                chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.addLast(new WorldTickHandler.RetroChunkCoord((Pair<Integer, Integer>)cCoord, list));
                WorldTickHandler.chunksToGen.put(dim, (Object)chunks);
            }
        }
    }
}

