/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.FMLEventHandlers;
import mcjty.deepresonance.ForgeEventHandlers;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.laser.LaserBonusConfiguration;
import mcjty.deepresonance.crafting.ModCrafting;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.gui.GuiProxy;
import mcjty.deepresonance.items.ModItems;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.radiation.RadiationTickEvent;
import mcjty.deepresonance.worldgen.WorldGen;
import mcjty.deepresonance.worldgen.WorldGenConfiguration;
import mcjty.deepresonance.worldgen.WorldTickHandler;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.varia.WrenchChecker;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        GeneralConfig.preInit((FMLPreInitializationEvent)e);
        this.mainConfig = DeepResonance.config;
        this.readMainConfig();
        DRMessages.registerNetworkMessages();
        DRFluidRegistry.preInitFluids();
        ModItems.init();
        ModBlocks.init();
        ModCrafting.init();
        WorldGen.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("worldgen", "Configuration for wodlgen");
            cfg.addCustomCategoryComment("generator", "Configuration for the generator multiblock");
            cfg.addCustomCategoryComment("radiation", "Configuration for the radiation");
            cfg.addCustomCategoryComment("laserbonus", "Configuration for the laser bonuses");
            WorldGenConfiguration.init(cfg);
            GeneratorConfiguration.init(cfg);
            RadiationConfiguration.init(cfg);
            LaserBonusConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)DeepResonance.instance, (IGuiHandler)new GuiProxy());
        FMLCommonHandler.instance().bus().register((Object)WorldTickHandler.instance);
        FMLCommonHandler.instance().bus().register((Object)new RadiationTickEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandlers());
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
        WrenchChecker.init();
    }

    public abstract void throwException(Exception var1, int var2);
}

