/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.deepresonance.items.RadiationMonitorItem;
import mcjty.deepresonance.network.PacketReturnRadiation;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class PacketGetRadiationLevel
implements IMessage,
IMessageHandler<PacketGetRadiationLevel, PacketReturnRadiation> {
    private GlobalCoordinate coordinate;

    public void fromBytes(ByteBuf buf) {
        int dim = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.coordinate = new GlobalCoordinate(new Coordinate(x, y, z), dim);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.coordinate.getDimension());
        buf.writeInt(this.coordinate.getCoordinate().getX());
        buf.writeInt(this.coordinate.getCoordinate().getY());
        buf.writeInt(this.coordinate.getCoordinate().getZ());
    }

    public PacketGetRadiationLevel() {
    }

    public PacketGetRadiationLevel(GlobalCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public PacketReturnRadiation onMessage(PacketGetRadiationLevel message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.field_70170_p;
        float strength = RadiationMonitorItem.calculateRadiationStrength(world, message.coordinate);
        return new PacketReturnRadiation(strength);
    }
}

