/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.network.PacketGetRadiationLevel;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class RadiationMonitorItem
extends Item {
    private static long lastTime = 0L;
    public static float radiationStrength = 0.0f;
    private IIcon[] radiationLevel = new IIcon[10];

    public RadiationMonitorItem() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            GlobalCoordinate c = new GlobalCoordinate(new Coordinate((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), world.field_73011_w.field_76574_g);
            float maxStrength = RadiationMonitorItem.calculateRadiationStrength(world, c);
            if (maxStrength <= 0.0f) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.GREEN + "No radiation detected"));
            } else {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Strength of Radiation " + new Float(maxStrength).intValue() + "!"));
            }
        }
        return stack;
    }

    private static double getDistanceSq(Coordinate c1, Coordinate c2) {
        double dx = c1.getX() - c2.getX();
        double dy = c1.getY() - c2.getY();
        double dz = c1.getZ() - c2.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public static float calculateRadiationStrength(World world, GlobalCoordinate player) {
        int id = player.getDimension();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        float maxStrength = -1.0f;
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> source : radiationManager.getRadiationSources().entrySet()) {
            int cz;
            int cy;
            GlobalCoordinate coordinate = source.getKey();
            if (coordinate.getDimension() != id) continue;
            DRRadiationManager.RadiationSource radiationSource = source.getValue();
            float radius = radiationSource.getRadius();
            float radiusSq = radius * radius;
            double distanceSq = RadiationMonitorItem.getDistanceSq(player.getCoordinate(), coordinate.getCoordinate());
            if (!(distanceSq < (double)radiusSq)) continue;
            double distance = Math.sqrt(distanceSq);
            float strength = (float)((double)radiationSource.getStrength() * ((double)radius - distance) / (double)radius);
            int cx = coordinate.getCoordinate().getX();
            QuadTree radiationTree = radiationSource.getRadiationTree(world, cx, cy = coordinate.getCoordinate().getY(), cz = coordinate.getCoordinate().getZ());
            if (!((strength *= (float)radiationTree.factor(cx, cy, cz, player.getCoordinate().getX(), player.getCoordinate().getY(), player.getCoordinate().getZ())) > maxStrength)) continue;
            maxStrength = strength;
        }
        return maxStrength;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i <= 9; ++i) {
            this.radiationLevel[i] = iconRegister.func_94245_a("deepresonance:radiationMonitorItem" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        RadiationMonitorItem.fetchRadiation((EntityPlayer)player);
        int level = (int)(10.0f * radiationStrength / RadiationConfiguration.maxRadiationMeter);
        if (level < 0) {
            level = 0;
        } else if (level > 9) {
            level = 9;
        }
        return this.radiationLevel[level];
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111208_A() {
        int level = (int)(10.0f * radiationStrength / RadiationConfiguration.maxRadiationMeter);
        if (level < 0) {
            level = 0;
        } else if (level > 9) {
            level = 9;
        }
        return "deepresonance:radiationMonitorItem" + level;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        RadiationMonitorItem.fetchRadiation(player);
        if (radiationStrength <= 0.0f) {
            list.add(EnumChatFormatting.GREEN + "No radiation detected");
        } else {
            list.add(EnumChatFormatting.RED + "Radiation: " + new Float(radiationStrength).intValue() + "!");
        }
    }

    public static void fetchRadiation(EntityPlayer player) {
        if (System.currentTimeMillis() - lastTime > 250L) {
            int id = player.field_70170_p.field_73011_w.field_76574_g;
            lastTime = System.currentTimeMillis();
            GlobalCoordinate c = new GlobalCoordinate(new Coordinate((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), id);
            DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketGetRadiationLevel(c));
        }
    }
}

