/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.grid.fluid;

import com.google.common.collect.Lists;
import elec332.core.grid.basic.AbstractCableGrid;
import elec332.core.grid.basic.AbstractGridTile;
import elec332.core.grid.basic.AbstractWiringTypeHelper;
import elec332.core.main.ElecCore;
import elec332.core.registry.AbstractWorldRegistryHolder;
import elec332.core.util.BlockLoc;
import elec332.core.world.WorldHelper;
import java.util.List;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.api.fluid.IDeepResonanceFluidAcceptor;
import mcjty.deepresonance.api.fluid.IDeepResonanceFluidProvider;
import mcjty.deepresonance.blocks.duct.TileBasicFluidDuct;
import mcjty.deepresonance.grid.InternalGridTank;
import mcjty.deepresonance.grid.fluid.DRFluidTile;
import mcjty.deepresonance.grid.fluid.DRFluidWorldGridHolder;
import mcjty.deepresonance.grid.fluid.DRGridTypeHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DRFluidDuctGrid
extends AbstractCableGrid<DRFluidDuctGrid, DRFluidTile, DRGridTypeHelper, DRFluidWorldGridHolder> {
    private InternalGridTank tank;
    private List<BlockLoc> tanks;

    public DRFluidDuctGrid(World world, DRFluidTile p, ForgeDirection direction) {
        super(world, (AbstractGridTile)p, direction, (AbstractWiringTypeHelper)DRGridTypeHelper.instance, (AbstractWorldRegistryHolder)DeepResonance.worldGridRegistry.getFluidRegistry());
        this.tank = new InternalGridTank(p.getTankStorage());
        this.tanks = Lists.newArrayList();
        if (p.getTile() instanceof TileBasicFluidDuct) {
            this.tank.fill(((TileBasicFluidDuct)p.getTile()).intTank, true);
        }
    }

    protected void uponGridMerge(DRFluidDuctGrid grid) {
        super.uponGridMerge((AbstractCableGrid)grid);
        this.tank.merge(grid.tank);
        this.tanks.addAll(grid.tanks);
    }

    public void onTick() {
        for (BlockLoc loc : this.locations) {
            ElecCore.systemPrintDebug((Object)loc);
        }
        this.processLiquids();
    }

    public void addTank(BlockLoc tank) {
        if (!this.tanks.contains(tank)) {
            this.tanks.add(tank);
        }
    }

    public void removeTank(BlockLoc tank) {
        this.tanks.remove(tank);
    }

    private void processLiquids() {
        block8: {
            int[] va;
            int requestedRCL;
            block7: {
                int e;
                requestedRCL = 0;
                va = new int[this.acceptors.size()];
                int[] vt = new int[this.tanks.size()];
                for (AbstractCableGrid.GridData gridData : this.providers) {
                    int maxProvide = this.tank.getMaxAmount() - this.getStoredAmount();
                    this.tank.fill(((IDeepResonanceFluidProvider)((DRFluidTile)((DRFluidWorldGridHolder)this.getWorldHolder()).getPowerTile(gridData.getLoc())).getTile()).getProvidedFluid(maxProvide, gridData.getDirection()), true);
                }
                for (AbstractCableGrid.GridData gridData : this.acceptors) {
                    va[this.acceptors.indexOf((Object)gridData)] = e = ((IDeepResonanceFluidAcceptor)((DRFluidTile)((DRFluidWorldGridHolder)this.getWorldHolder()).getPowerTile(gridData.getLoc())).getTile()).getRequestedAmount(gridData.getDirection());
                    requestedRCL += e;
                }
                for (BlockLoc loc : this.tanks) {
                    va[this.tanks.indexOf((Object)loc)] = e = ((IDeepResonanceFluidAcceptor)WorldHelper.getTileAt((IBlockAccess)this.world, (BlockLoc)loc)).getRequestedAmount(ForgeDirection.UNKNOWN);
                    requestedRCL += e;
                }
                if (this.getStoredAmount() < requestedRCL) break block7;
                for (AbstractCableGrid.GridData gridData : this.acceptors) {
                    ((IDeepResonanceFluidAcceptor)((DRFluidTile)((DRFluidWorldGridHolder)this.getWorldHolder()).getPowerTile(gridData.getLoc())).getTile()).acceptFluid(this.tank.drain(va[this.acceptors.indexOf(gridData)], true), gridData.getDirection());
                }
                for (BlockLoc loc : this.tanks) {
                    ((IDeepResonanceFluidAcceptor)WorldHelper.getTileAt((IBlockAccess)this.world, (BlockLoc)loc)).acceptFluid(this.tank.drain(va[this.tanks.indexOf(loc)], true), ForgeDirection.UNKNOWN);
                }
                break block8;
            }
            if (this.getStoredAmount() <= 0) break block8;
            float diff = (float)this.getStoredAmount() / (float)requestedRCL;
            for (AbstractCableGrid.GridData gridData : this.acceptors) {
                ((IDeepResonanceFluidAcceptor)((DRFluidTile)((DRFluidWorldGridHolder)this.getWorldHolder()).getPowerTile(gridData.getLoc())).getTile()).acceptFluid(this.tank.drain((int)((float)va[this.acceptors.indexOf(gridData)] * diff), true), gridData.getDirection());
            }
            for (BlockLoc loc : this.tanks) {
                ((IDeepResonanceFluidAcceptor)WorldHelper.getTileAt((IBlockAccess)this.world, (BlockLoc)loc)).acceptFluid(this.tank.drain((int)((float)va[this.tanks.indexOf(loc)] * diff), true), ForgeDirection.UNKNOWN);
            }
        }
    }

    protected void onTileRemoved(DRFluidTile tile) {
        FluidStack stack;
        super.onTileRemoved((AbstractGridTile)tile);
        for (AbstractCableGrid.GridData gridData : this.transmitters) {
            TileEntity tileEntity = WorldHelper.getTileAt((IBlockAccess)this.world, (BlockLoc)gridData.getLoc());
            if (tileEntity == null) {
                tileEntity = tile.getTile();
            }
            if (!(tileEntity instanceof TileBasicFluidDuct)) continue;
            ((TileBasicFluidDuct)tileEntity).intTank = this.getFluidShare(tile.getTile());
            ((TileBasicFluidDuct)tileEntity).lastSeenFluid = this.tank.getStoredFluid();
        }
        if (tile.getTile() instanceof TileBasicFluidDuct && (stack = ((TileBasicFluidDuct)tile.getTile()).intTank) != null) {
            this.tank.drain(stack.amount, true);
        }
    }

    public Fluid getFluid() {
        return this.tank.getStoredFluid();
    }

    public FluidStack getFluidShare(TileEntity tile) {
        if (tile instanceof TileBasicFluidDuct) {
            return this.tank.getShare(this.transmitters.size());
        }
        return null;
    }

    public int addStackToInternalTank(FluidStack stack, boolean doFill) {
        return this.tank.fill(stack, doFill);
    }

    public String getInfo() {
        return this.tank.getInfo();
    }

    public int getStoredAmount() {
        return this.tank.getStoredAmount();
    }
}

