/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.smelter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import elec332.core.world.WorldHelper;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.base.ElecEnergyReceiverTileBase;
import mcjty.deepresonance.blocks.smelter.SmelterContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SmelterTileEntity
extends ElecEnergyReceiverTileBase
implements ITankHook,
ISidedInventory {
    public static final String CMD_GETPROGRESS = "getProgress";
    public static final String CLIENTCMD_GETPROGRESS = "getProgress";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, SmelterContainer.factory, 1);
    private int totalProgress = 0;
    private int progress = 0;
    private TileTank lavaTank;
    private TileTank rclTank;
    private boolean checkTanks = true;
    private float finalQuality = 1.0f;
    private float finalPurity = 0.1f;
    private static int progressPercentage = 0;

    public SmelterTileEntity() {
        super(ConfigMachines.Smelter.rfMaximum, ConfigMachines.Smelter.rfPerTick);
    }

    protected void checkStateServer() {
        if (this.progress > 0) {
            if (this.canWork()) {
                --this.progress;
                this.storage.extractEnergy(ConfigMachines.Smelter.rfPerOre, false);
                if (this.progress == 0) {
                    this.stopSmelting();
                }
            }
        } else {
            int meta2;
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.canWork() && this.validSlot()) {
                this.startSmelting();
                meta2 = BlockTools.setRedstoneSignalIn((int)meta, (boolean)true);
            } else {
                meta2 = BlockTools.setRedstoneSignalIn((int)meta, (boolean)false);
            }
            if (meta != meta2) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta2, 3);
            }
        }
    }

    public static int getProgressPercentage() {
        return progressPercentage;
    }

    private boolean canWork() {
        if (this.checkTanks) {
            if (this.checkTanks()) {
                this.checkTanks = false;
            } else {
                return false;
            }
        }
        return this.storage.getEnergyStored() >= ConfigMachines.Smelter.rfPerOre;
    }

    private boolean checkTanks() {
        return this.lavaTank != null && this.rclTank != null && DRFluidRegistry.getFluidFromStack(this.lavaTank.getFluid()) == FluidRegistry.LAVA && (float)this.lavaTank.getFluidAmount() > (float)this.lavaTank.getCapacity() * 0.25f && this.rclTank.fill(ForgeDirection.UNKNOWN, new FluidStack(DRFluidRegistry.liquidCrystal, ConfigMachines.Smelter.rclPerOre), false) == ConfigMachines.Smelter.rclPerOre;
    }

    private boolean validSlot() {
        return this.inventoryHelper.getStackInSlot(0) != null && this.inventoryHelper.getStackInSlot(0).func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingOreBlock);
    }

    private void startSmelting() {
        this.inventoryHelper.decrStackSize(0, 1);
        float percentage = (float)this.lavaTank.getFluidAmount() / (float)this.lavaTank.getCapacity();
        if (percentage < 0.4f) {
            this.finalQuality = 1.0f - (0.4f - percentage);
            this.finalPurity = 0.1f;
        } else if (percentage > 0.75f) {
            this.finalQuality = -1.0f;
            this.finalPurity = 0.0f;
        } else if (percentage > 0.6f) {
            this.finalQuality = 1.0f - (percentage - 0.6f) * 6.666f;
            this.finalPurity = 0.1f - (percentage - 0.6f) * 0.3f;
        } else {
            this.finalQuality = 1.0f;
            this.finalPurity = 0.1f;
        }
        this.lavaTank.drain(ForgeDirection.UNKNOWN, new FluidStack(FluidRegistry.LAVA, ConfigMachines.Smelter.lavaCost), true);
        this.totalProgress = this.progress = ConfigMachines.Smelter.processTime + (int)((percentage - 0.5f) * (float)ConfigMachines.Smelter.processTime);
    }

    private void stopSmelting() {
        if (this.finalQuality > 0.0f) {
            FluidStack stack = LiquidCrystalFluidTagData.makeLiquidCrystalStack(ConfigMachines.Smelter.rclPerOre, this.finalQuality, this.finalPurity, 0.1f, 0.1f);
            this.rclTank.fill(ForgeDirection.UNKNOWN, stack, true);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("totalProgress", this.totalProgress);
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74776_a("finalQuality", this.finalQuality);
        tagCompound.func_74776_a("finalPurity", this.finalPurity);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.totalProgress = tagCompound.func_74762_e("totalProgress");
        this.progress = tagCompound.func_74762_e("progress");
        this.finalQuality = tagCompound.func_74760_g("finalQuality");
        this.finalPurity = tagCompound.func_74760_g("finalPurity");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    @Override
    public void hook(TileTank tank, ForgeDirection direction) {
        if (direction == ForgeDirection.DOWN) {
            this.lavaTank = tank;
        } else if (this.rclTank == null && this.validRCLTank(tank)) {
            this.rclTank = tank;
        }
        this.checkTanks = true;
    }

    @Override
    public void unHook(TileTank tank, ForgeDirection direction) {
        if (this.tilesEqual(this.lavaTank, tank)) {
            this.lavaTank = null;
        } else if (this.tilesEqual(this.rclTank, tank)) {
            this.rclTank = null;
            this.notifyNeighboursOfDataChange();
        }
        this.checkTanks = true;
    }

    @Override
    public void onContentChanged(TileTank tank, ForgeDirection direction) {
        if (this.tilesEqual(this.rclTank, tank) && !this.validRCLTank(tank)) {
            this.rclTank = null;
        }
        this.checkTanks = true;
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.myLocation().equals((Object)second.myLocation()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return SmelterContainer.factory.isInputSlot(index) || SmelterContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return SmelterContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Smelter Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void requestProgressFromServer() {
        DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getProgress", "getProgress", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getProgress".equals(command)) {
            if (this.totalProgress == 0) {
                return 0;
            }
            return (this.totalProgress - this.progress) * 100 / this.totalProgress;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getProgress".equals(command)) {
            progressPercentage = result;
            return true;
        }
        return false;
    }
}

