/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileEntitySteamEngine
extends TileEntityEngine {
    private int dryTicks = 0;

    @Override
    public boolean canConsumeFuel() {
        return this.water.getLevel() > 0 && this.temperature >= 100;
    }

    @Override
    public int getMaxTemperature() {
        return 150;
    }

    @Override
    protected void consumeFuel() {
        this.water.removeLiquid(this.getConsumedFuel());
    }

    @Override
    protected void offlineCooldown(World world, int x, int y, int z, int Tamb) {
    }

    @Override
    protected int getConsumedFuel() {
        int amt = 10;
        if (this.temperature >= 130) {
            amt = 75;
        } else if (this.temperature >= 125) {
            amt = 60;
        } else if (this.temperature >= 120) {
            amt = 50;
        } else if (this.temperature >= 110) {
            amt = 25;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150353_l) {
            amt *= 4;
        }
        return amt;
    }

    @Override
    protected void internalizeFuel() {
        if (this.water.isEmpty() && this.temperature >= 100) {
            ++this.dryTicks;
        } else {
            if (this.dryTicks > 900 && !this.water.isEmpty()) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 6.0f, false);
            }
            this.dryTicks = 0;
        }
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        if (this.temperature < 100) {
            return false;
        }
        if (this.water.isEmpty()) {
            return false;
        }
        RotaryAchievements.STEAMENGINE.triggerAchievement(this.getPlacer());
        return true;
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.STEAM.playSoundAtBlock(world, x, y, z, 0.7f * volume, 1.0f * pitchMultiplier);
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        super.updateTemperature(world, x, y, z, meta);
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        BiomeGenBase biome = world.func_72807_a(x, z);
        boolean fire = RotaryAux.isAboveFire(world, x, y, z);
        boolean lava = RotaryAux.isAboveLava(world, x, y, z);
        if (biome == BiomeGenBase.field_76778_j) {
            Tamb = 101;
        }
        if (fire) {
            ++this.temperature;
        }
        if (fire && biome == BiomeGenBase.field_76778_j) {
            ++this.temperature;
        }
        if (lava) {
            this.temperature += 2;
        }
        if (Tamb < 0 && fire) {
            Tamb += 30;
        }
        if (this.temperature < Tamb) {
            this.temperature += ReikaMathLibrary.extrema((int)((Tamb - this.temperature) / 40), (int)1, (String)"max");
        }
        if (!fire && !lava && this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb) {
            this.temperature -= (this.temperature - Tamb) / 96;
        }
        if (this.temperature > this.getMaxTemperature()) {
            this.overheat(world, x, y, z);
        }
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        if (this.water.isEmpty()) {
            return;
        }
        this.temperature = this.getMaxTemperature();
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap.func_77946_l(), (int)0, (int)17, (boolean)false, (float)1.0f, (boolean)false, (boolean)true, (float)2.0f);
        RotaryAchievements.OVERPRESSURE.triggerAchievement(this.getPlacer());
        world.func_147468_f(x, y, z);
    }

    @Override
    public int getFuelLevel() {
        return this.water.getLevel();
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("dry", this.dryTicks);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.dryTicks = NBT.func_74762_e("dry");
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }
}

