/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.MagnetizationCore;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RedstoneCycleTracker;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityACEngine
extends TileEntityEngine
implements MagnetizationCore {
    private final RedstoneCycleTracker redstone = new RedstoneCycleTracker(3);

    @Override
    protected void consumeFuel() {
    }

    @Override
    protected void internalizeFuel() {
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        ItemStack is = this.inv[0];
        if (is == null) {
            return false;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.shaftcore)) {
            return false;
        }
        if (is.field_77990_d == null) {
            return false;
        }
        if (!is.field_77990_d.func_74764_b("magnet")) {
            return false;
        }
        if (is.field_77990_d.func_74762_e("magnet") <= 0) {
            return false;
        }
        this.redstone.update(world, x, y, z);
        boolean ac = this.redstone.isAlternating();
        if (!world.field_72995_K && ac && this.timer.checkCap("fuel")) {
            int m = is.field_77990_d.func_74762_e("magnet");
            this.magnetize(is, m - 1);
        }
        return ac;
    }

    private void magnetize(ItemStack is, int amt) {
        if (amt > 0) {
            is.field_77990_d.func_74768_a("magnet", amt);
        } else {
            is.field_77990_d.func_82580_o("magnet");
            if (is.field_77990_d.func_82582_d()) {
                is.field_77990_d = null;
            }
        }
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.ELECTRIC.playSoundAtBlock(world, x, y, z, 0.125f * volume, 1.0f * pitchMultiplier);
    }

    public void magneticInterference(int mag, double dd) {
        this.torque = (int)(0.0625 * ReikaMathLibrary.logbase((long)mag, (int)2) * (double)this.getEngineType().getTorque() / dd);
        this.omega = (int)(0.0625 * ReikaMathLibrary.logbase((long)mag, (int)2) * (double)this.getEngineType().getSpeed() / dd / 4.0);
        this.power = (long)this.omega * (long)this.torque;
    }

    @Override
    public int getFuelLevel() {
        return 0;
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
    }

    @Override
    public int getCoreMagnetization() {
        return this.inv[0] != null && this.inv[0].field_77990_d != null ? this.inv[0].field_77990_d.func_74762_e("magnet") : 0;
    }

    @Override
    public void addRedstoneUpgrade() {
        this.redstone.addIntegrated();
    }

    @Override
    public boolean hasRedstoneUpgrade() {
        return this.redstone.hasIntegrated();
    }

    @Override
    public void upgrade(ItemStack is) {
        this.addRedstoneUpgrade();
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return !this.hasRedstoneUpgrade() && ItemRegistry.UPGRADE.matchItem(item) && item.func_77960_j() == ItemEngineUpgrade.Upgrades.REDSTONE.ordinal();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("redstoneUpgrade", this.redstone.hasIntegrated());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.redstone.reset();
        if (NBT.func_74767_n("redstoneUpgrade")) {
            this.redstone.addIntegrated();
        }
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
        if (this.hasRedstoneUpgrade()) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ItemRegistry.UPGRADE.getStackOfMetadata(ItemEngineUpgrade.Upgrades.REDSTONE.ordinal()));
        }
    }
}

