/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.Auxiliary.EnumDifficulty;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.BlastGate;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class RotaryConfig
extends ControlledConfig {
    private static final ArrayList<String> entries = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(RotaryAchievements.class);
    private final ControlledConfig.DataElement<Integer>[] achievementIDs = new ControlledConfig.DataElement[entries.size()];
    private ControlledConfig.DataElement<String[]> blastGate;
    private ControlledConfig.DataElement<String> bedrockGate;
    private ControlledConfig.DataElement<String> gravelGate;
    public static final int friction = 0;
    public static final int torquelimit = 0x3FFFFFFF;
    public static final int omegalimit = 0x3FFFFFFF;
    public static final boolean debugmode = false;
    public static final EnumDifficulty EASIEST = EnumDifficulty.EASY;
    public static final EnumDifficulty HARDEST = EnumDifficulty.HARD;

    public RotaryConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        super(mod, option, id);
        for (int i = 0; i < entries.size(); ++i) {
            String name = entries.get(i);
            this.achievementIDs[i] = this.registerAdditionalOption("Achievement IDs", name, 24000 + i);
        }
        this.blastGate = this.registerAdditionalOption("Other Options", "Alternate Blast Furnace Materials", new String[0]);
        this.bedrockGate = this.registerAdditionalOption("Other Options", "Bedrock Armor Gating Material", "");
        this.gravelGate = this.registerAdditionalOption("Other Options", "Gravel Gun Gating Material", "");
    }

    protected void onInit() {
    }

    public int getAchievementID(int idx) {
        return (Integer)this.achievementIDs[idx].getData();
    }

    public ItemStack getBedrockArmorGatingMaterial(boolean check, ItemStack obj) {
        String item = (String)this.bedrockGate.getData();
        if (!check || item == null || item.length() == 0) {
            return obj;
        }
        return this.getGatedMaterial(item, obj);
    }

    public ItemStack getGravelGunGatingMaterial(boolean check, ItemStack obj) {
        String item = (String)this.gravelGate.getData();
        if (!check || item == null || item.length() == 0) {
            return obj;
        }
        return this.getGatedMaterial(item, obj);
    }

    private ItemStack getGatedMaterial(String item, ItemStack obj) {
        BlastGate g = null;
        try {
            g = BlastGate.valueOf(item.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (g == null) {
            RotaryCraft.logger.logError((Object)("Gating material '" + item + "' is invalid."));
            return obj;
        }
        ItemStack ret = ReikaItemHelper.parseItem((Object)g.getItem());
        if (ret == null) {
            RotaryCraft.logger.logError((Object)("Selected gating material " + (Object)((Object)g) + " could not be found; either the item does not exist or its mods have not yet loaded."));
        }
        return obj;
    }

    public Object[] getBlastFurnaceGatingMaterials(boolean check, Object obj1, Object obj2, Object obj3, Object obj4) {
        String[] arr = (String[])this.blastGate.getData();
        if (!check || arr == null || arr.length == 0) {
            return new Object[]{obj1, obj2, obj3, obj4};
        }
        ArrayList<Object> c = new ArrayList<Object>();
        boolean invalid = false;
        for (int i = 0; i < arr.length; ++i) {
            String idx = arr[i].toUpperCase();
            BlastGate g = null;
            try {
                g = BlastGate.valueOf(idx);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (g == null) {
                RotaryCraft.logger.logError((Object)("Gating material '" + idx + "' is invalid."));
                invalid = true;
                continue;
            }
            Object item = g.getItem();
            if (item == null) {
                RotaryCraft.logger.logError((Object)("Selected gating material " + (Object)((Object)g) + " could not be found; either the item does not exist or its mods have not yet loaded."));
                continue;
            }
            c.add(item);
        }
        if (invalid) {
            RotaryCraft.logger.log((Object)"Valid materials (case insensitive):");
            StringBuilder sb = new StringBuilder();
            for (BlastGate g : BlastGate.values()) {
                sb.append(g.name() + "; ");
            }
            RotaryCraft.logger.log((Object)sb.toString());
        }
        switch (c.size()) {
            case 1: {
                obj3 = obj4 = c.get(0);
                obj2 = obj4;
                obj1 = obj4;
                break;
            }
            case 2: {
                obj1 = obj4 = c.get(0);
                obj2 = obj3 = c.get(1);
                break;
            }
            case 3: {
                obj1 = obj4 = c.get(0);
                obj2 = c.get(1);
                obj3 = c.get(2);
                break;
            }
            case 4: {
                obj1 = c.get(0);
                obj2 = c.get(1);
                obj3 = c.get(2);
                obj4 = c.get(3);
                break;
            }
        }
        return new Object[]{obj1, obj2, obj3, obj4};
    }
}

