/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum MobBait {
    CREEPER(EntityCreeper.class, 50, Blocks.field_150335_W, Blocks.field_150343_Z),
    ENDERMAN(EntityEnderman.class, 58, (Block)Blocks.field_150349_c, Blocks.field_150425_aM),
    ZOMBIE(EntityZombie.class, 54, Items.field_151153_ao, 0, (Item)Items.field_151068_bn, 8197),
    SKELETON(EntitySkeleton.class, 51, Items.field_151141_av, Blocks.field_150426_aN),
    SPIDER(EntitySpider.class, 52, Items.field_151100_aR, ReikaItemHelper.cocoaBeans.func_77960_j(), Blocks.field_150422_aJ, -1),
    SLIME(EntitySlime.class, 55, Items.field_151045_i, Blocks.field_150432_aD),
    BLAZE(EntityBlaze.class, 61, Items.field_151059_bz, Items.field_151131_as),
    PIGZOMBIE(EntityPigZombie.class, 57, Items.field_151034_e, Items.field_151072_bj),
    LAVASLIME(EntityMagmaCube.class, 62, Items.field_151065_br, Items.field_151126_ay),
    GHAST(EntityGhast.class, 56, Items.field_151114_aO, (Item)Items.field_151031_f),
    SILVERFISH(EntitySilverfish.class, 60, Blocks.field_150417_aV, Items.field_151039_o),
    VILLAGER(EntityVillager.class, 120, Items.field_151166_bC, Blocks.field_150434_aF),
    IRONGOLEM(EntityIronGolem.class, 99, Blocks.field_150325_L, ReikaItemHelper.redWool.metadata, Items.field_151129_at, -1),
    WITCH(EntityWitch.class, 66, Items.field_151075_bm, Items.field_151079_bi),
    SNOWGOLEM(EntitySnowman.class, 97, Items.field_151172_bF, Blocks.field_150478_aa),
    BAT(EntityBat.class, 65, Items.field_151127_ba, Blocks.field_150323_B),
    COW(EntityCow.class, 92, Items.field_151015_O, Items.field_151055_y),
    PIG(EntityPig.class, 90, Items.field_151172_bF, Items.field_151055_y),
    SHEEP(EntitySheep.class, 91, Items.field_151015_O, Items.field_151055_y),
    CHICKEN(EntityChicken.class, 93, Items.field_151014_N, Items.field_151055_y),
    OCELOT(EntityOcelot.class, 98, Items.field_151115_aP, Items.field_151055_y),
    WOLF(EntityWolf.class, 95, Items.field_151147_al, Blocks.field_150351_n),
    SQUID(EntitySquid.class, 94, Items.field_151043_k, Blocks.field_150392_bi);

    private Class entityClass;
    private Item attractorID;
    private int attractorMetadata;
    private Item repellentID;
    private int repellentMetadata;
    private int entityID;
    public static final MobBait[] baitList;

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Item a, Item r) {
        this(cl, id, a, -1, r, -1);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Block a, Item r) {
        this(cl, id, Item.func_150898_a((Block)a), -1, r, -1);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Item a, Block r) {
        this(cl, id, a, -1, Item.func_150898_a((Block)r), -1);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Block a, Block r) {
        this(cl, id, Item.func_150898_a((Block)a), -1, Item.func_150898_a((Block)r), -1);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Block a, int am, Item r, int rm) {
        this(cl, id, Item.func_150898_a((Block)a), am, r, rm);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Item a, int am, Block r, int rm) {
        this(cl, id, a, am, Item.func_150898_a((Block)r), rm);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Block a, int am, Block r, int rm) {
        this(cl, id, Item.func_150898_a((Block)a), am, Item.func_150898_a((Block)r), rm);
    }

    private MobBait(Class<? extends EntityLivingBase> cl, int id, Item a, int am, Item r, int rm) {
        this.entityClass = cl;
        this.attractorID = a;
        this.repellentID = r;
        this.attractorMetadata = am;
        this.repellentMetadata = rm;
        this.entityID = id;
    }

    public static MobBait getEntryFromEntity(EntityLivingBase e) {
        Class<?> c = e.getClass();
        MobBait strict = null;
        MobBait len = null;
        for (int i = 0; i < baitList.length; ++i) {
            if (c == MobBait.baitList[i].entityClass) {
                strict = baitList[i];
            }
            if (!MobBait.baitList[i].entityClass.isAssignableFrom(c)) continue;
            len = baitList[i];
        }
        return strict != null ? strict : len;
    }

    public Item getAttractorItemID() {
        return this.attractorID;
    }

    public int getAttractorItemDamage() {
        return this.attractorMetadata;
    }

    public Item getRepellentItemID() {
        return this.repellentID;
    }

    public int getRepellentItemDamage() {
        return this.repellentMetadata;
    }

    public ItemStack getAttractorItemStack() {
        if (this.isMetadataValuedAttractor()) {
            return new ItemStack(this.attractorID, 1, this.attractorMetadata);
        }
        return new ItemStack(this.attractorID, 1, 0);
    }

    public ItemStack getRepellentItemStack() {
        if (this.isMetadataValuedRepellent()) {
            return new ItemStack(this.repellentID, 1, this.repellentMetadata);
        }
        return new ItemStack(this.repellentID, 1, 0);
    }

    public static ItemStack getEntityAttractor(EntityLivingBase e) {
        MobBait mb = MobBait.getEntryFromEntity(e);
        if (mb.isMetadataValuedAttractor()) {
            return new ItemStack(mb.attractorID, 1, mb.attractorMetadata);
        }
        return new ItemStack(mb.attractorID, 1, 0);
    }

    public static ItemStack getEntityRepellent(EntityLivingBase e) {
        MobBait mb = MobBait.getEntryFromEntity(e);
        if (mb.isMetadataValuedRepellent()) {
            return new ItemStack(mb.repellentID, 1, mb.repellentMetadata);
        }
        return new ItemStack(mb.repellentID, 1, 0);
    }

    public boolean isMetadataValuedAttractor() {
        return this.attractorMetadata != -1;
    }

    public boolean isMetadataValuedRepellent() {
        return this.attractorMetadata != -1;
    }

    public static List<ItemStack> getAllAttractorItems() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (int i = 0; i < baitList.length; ++i) {
            l.add(baitList[i].getAttractorItemStack());
        }
        return l;
    }

    public static List<ItemStack> getAllRepellentItems() {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (int i = 0; i < baitList.length; ++i) {
            l.add(baitList[i].getRepellentItemStack());
        }
        return l;
    }

    public static boolean isValidItem(ItemStack is) {
        List<ItemStack> att = MobBait.getAllAttractorItems();
        List<ItemStack> rep = MobBait.getAllRepellentItems();
        return att.contains(is) || rep.contains(is);
    }

    public static boolean hasRepelItem(EntityLivingBase e, ItemStack[] inv) {
        if (!MobBait.isAffectableEntity(e)) {
            return false;
        }
        ItemStack is = MobBait.getEntityRepellent(e);
        return ReikaInventoryHelper.checkForItemStack((ItemStack)is, (ItemStack[])inv, (boolean)false);
    }

    public static boolean hasAttractItem(EntityLivingBase e, ItemStack[] inv) {
        if (!MobBait.isAffectableEntity(e)) {
            return false;
        }
        ItemStack is = MobBait.getEntityAttractor(e);
        return ReikaInventoryHelper.checkForItemStack((ItemStack)is, (ItemStack[])inv, (boolean)false);
    }

    public static boolean isAffectableEntity(EntityLivingBase e) {
        return MobBait.getEntryFromEntity(e) != null;
    }

    public int getMobIconU() {
        int UNIT = 4;
        int v = 2 * UNIT * (this.entityID / 16);
        int u = 2 * UNIT * (this.entityID - v / UNIT / 2 * 16);
        return u;
    }

    public int getMobIconV() {
        int UNIT = 4;
        int v = 2 * UNIT * (this.entityID / 16);
        int u = 2 * UNIT * (this.entityID - v / UNIT / 2 * 16);
        return v;
    }

    public String getCommandSenderName() {
        return (String)EntityList.field_75625_b.get(this.entityClass);
    }

    static {
        baitList = MobBait.values();
    }
}

