/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Auxiliary.EnumDifficulty;
import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.DecimalConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.MatchingConfig;
import Reika.DragonAPI.Interfaces.Configuration.SegmentedConfigList;
import Reika.DragonAPI.Interfaces.Configuration.SelectiveConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import Reika.DragonAPI.Interfaces.Configuration.UserSpecificConfig;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Registry.PowerReceivers;
import Reika.RotaryCraft.RotaryConfig;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.util.MathHelper;

public enum ConfigRegistry implements SegmentedConfigList,
SelectiveConfig,
IntegerConfig,
BooleanConfig,
DecimalConfig,
StringConfig,
MatchingConfig,
UserSpecificConfig
{
    ENGINEVOLUME("Engine Volume", 1.0f),
    GPRORES("GPR Renders Ores", true),
    INSTACUT("Instant Woodcutter", true),
    CRAFTABLEBEDROCK("Allow Craftable Bedrock", true),
    LOCKMACHINES("Owner-Only Machine Use", false),
    MACHINEVOLUME("Machine Volume Multiplier", 1.0f),
    FLOODLIGHTRANGE("Max Floodlight Range", 128),
    HEATRAYRANGE("Max Heat Ray Range", 128),
    BRIDGERANGE("Max Bridge Range", 128),
    FANRANGE("Max Fan Range", 128),
    AERORANGE("Max Aerosolizer Range", 128),
    VACUUMRANGE("Max Vacuum Range", 128),
    SONICRANGE("Max Sonic Weapon Range", 128),
    FORCERANGE("Max Force Field Range", 128),
    SONICBORERRANGE("Sonic Borer Range", 512),
    SPAWNERLIMIT("Spawner Mob Limit", 128),
    DETECTORRANGE("Player Detector Range", 128),
    BREEDERRANGE("Breeder Range", 128),
    BAITRANGE("Bait Box Range", 24),
    LINEBUILDER("Block Ram Range", 512),
    BAITMOBS("Max Bait Box Mob Count", 256),
    CAVEFINDERRANGE("Cave Scanner FOV", 16),
    BANRAIN("Disable Silver Iodide Cannon Rain", false),
    ACHIEVEMENTS("Enable Achievements", true),
    MODORES("Force Inter-Mod Ore Compatibility", true),
    BEDPICKSPAWNERS("Allow Bedrock Pickaxe to Harvest Spawners", true),
    SPAWNERLEAK("Spawn Mobs When Harvesting Spawners By Hand", true),
    BLOCKDAMAGE("Direct Block Damage from Machine Failures", true),
    DIFFICULTY("Difficulty Control", 2),
    ALARM("Machine Warning Alarms", false),
    BIOMEBLOCKS("Terraformer Block Editing", true),
    DYNAMICHANDBOOK("Reload Handbook Data on Open", false),
    TABLEMACHINES("Crafting Table can Make Machines", false),
    EMPLOAD("EMP Charging Speed", 4),
    ROTATEHOSE("Rotate Hose/Pipe/Fuel Line Recipes", false),
    RAILGUNDAMAGE("Railgun Block Damage", true),
    GRAVELPLAYER("Allow Gravel Gun PvP", true),
    CHESTGEN("Chest Generation Tier", 4),
    PROJECTORLINES("Render projector lines", true),
    COLORBLIND("Color Blind Mode", false),
    TURRETPLAYERS("Turrets can target players", true),
    HSLADICT("Allow RC steel to be used in other mods", false),
    PREENCHANT("Lock enchants on bedrock tools", true),
    SPRINKLER("Sprinkler Particle Density", 4),
    HANDBOOK("Spawn with RC Handbook", true),
    CONSERVEPACK("Conservative Jetpack Firing", true),
    ALLOWBAN("Allow Build Blocking of Some Machines", false),
    LOGBLOCKS("Log Block Placement and Removal", false),
    FLOWSPEED("Fluid Flow Speed", 5),
    ATTACKBLOCKS("Block Damage from Destructive Machines", true),
    VOIDHOLE("Allow Bedrock Breaker to Break Y=0", false),
    JETFUELPACK("Jetpack Requires Jet Fuel", false),
    ALLOWTNTCANNON("Allow TNT Cannon", true),
    ALLOWEMP("Allow EMP", true),
    EXTRAIRON("Iron Ore Density", 1.0f),
    TEGLASS("Allow Blast Glass to be Used as TE Hardened Glass", false),
    CLEARCHAT("Tools Clear Chat", true),
    KICKFLYING("Jetpack bypasses allow-flight property", true),
    BLOWERSPILL("Item Pump Spills Items If Dumping To Air", true),
    EXTRACTORMAINTAIN("Extractor Drill Wears Down", false),
    HARDGRAVELGUN("Hardmode Gravel Gun", false),
    BORERMAINTAIN("Borer Requires Maintenance", false),
    NOMINERS("Disable Automining Machines", false),
    HARDEU("Hard Mode EU Compatibility", ModList.GREGTECH.isLoaded()),
    PIPEHARDNESS("Pipe Block Hardness", 0.0f),
    FRICTIONXP("Spawn XP from Friction Heater", true),
    SPILLERRANGE("Liquid Spiller Range, Use Zero to Disable", 16),
    POWERCLIENT("Run power transfer code on client", false),
    TUTORIAL("Tutorial Mode", false),
    FRAMES("Allow Frames to move Machines (May cause corruption)", false),
    CONVERTERLOSS("Power Converter Loss Percent", 0),
    FAKEBEDROCK("Allow special bedrock tool abilities in automation", true),
    BORERGEN("Borer Chunk Gen Radius", 0),
    ALLOWLIGHTBRIDGE("Enable Light Bridge", true),
    ALLOWITEMCANNON("Enable Item Cannon", true),
    ALLOWCHUNKLOADER("Enable Chunk Loader", true),
    CHUNKLOADERSIZE("Chunk Loader Max Radius in Chunks", 8),
    RECIPEMOD("Allow Nonstandard Recipe Modifications", false),
    STRONGRECIPEMOD("Strong Recipe Editing", false),
    CORERECIPEMOD("Core Recipe Editing", "X"),
    CRAFTERPROFILE("AutoCrafter Lag Profiling And Compensation", true),
    HSLAHARVEST("Increased Harvest Level for HSLA", false),
    LATEDYNAMO("Rotational Dynamo Recipe Difficulty", 0),
    BORERPOW("Borer Power Requirement Factor", 1.0f),
    BEEYEAST("Use Forestry Bees To Produce Yeast", 0),
    HARDCONVERTERS("Harder Converter Unit Recipes", false),
    OREALUDUST("Allow other mods' aluminum dust to make Silicon", false),
    GATEBLAST("Enable Blast Furnace recipe gating", false),
    GATEWORK("Enable Worktable recipe gating", false),
    VACPOWER("Item Vacuum Power Per Meter", (int)PowerReceivers.VACUUM.getMinPower() / 4),
    HYDROSTREAMFALLMAX("Streams Waterfall Min Height for Max Hydrokinetic Yield", 8),
    TINKERFLAKES("TiC Smeltery Flake Yield Amount In Ingots", 1.5f),
    IC2BLAZECOMPRESS("Increase Blaze Powder To Rod Cost In IC2 Compressor (Exploit Fix)", true),
    FREEWATER("Free Water Production Factor", 1.0f);

    private String label;
    private boolean defaultState;
    private int defaultValue;
    private float defaultFloat;
    private String defaultString;
    private Class type;
    private boolean enforcing = false;
    public static final ConfigRegistry[] optionList;

    private ConfigRegistry(String l, boolean d) {
        this.label = l;
        this.defaultState = d;
        this.type = Boolean.TYPE;
    }

    private ConfigRegistry(String l, boolean d, boolean tag) {
        this(l, d);
        this.enforcing = true;
    }

    private ConfigRegistry(String l, int d) {
        this.label = l;
        this.defaultValue = d;
        this.type = Integer.TYPE;
    }

    private ConfigRegistry(String l, float d) {
        this.label = l;
        this.defaultFloat = d;
        this.type = Float.TYPE;
    }

    private ConfigRegistry(String l, String d) {
        this.label = l;
        this.defaultString = d;
        this.type = String.class;
    }

    public boolean isBoolean() {
        return this.type == Boolean.TYPE;
    }

    public boolean isNumeric() {
        return this.type == Integer.TYPE;
    }

    public boolean isDecimal() {
        return this.type == Float.TYPE;
    }

    public Class getPropertyType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isString() {
        return this.type == String.class;
    }

    public boolean getState() {
        return (Boolean)RotaryCraft.config.getControl(this.ordinal());
    }

    public int getValue() {
        if (this == DIFFICULTY) {
            return EnumDifficulty.getBoundedDifficulty((int)((Integer)RotaryCraft.config.getControl(this.ordinal())), (EnumDifficulty)RotaryConfig.EASIEST, (EnumDifficulty)RotaryConfig.HARDEST).ordinal();
        }
        return (Integer)RotaryCraft.config.getControl(this.ordinal());
    }

    public float getFloat() {
        return ((Float)RotaryCraft.config.getControl(this.ordinal())).floatValue();
    }

    public String getString() {
        return (String)RotaryCraft.config.getControl(this.ordinal());
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public boolean isDummiedOut() {
        return this.type == null;
    }

    public boolean getDefaultState() {
        return this.defaultState;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public float getDefaultFloat() {
        return this.defaultFloat;
    }

    public boolean isEnforcingDefaults() {
        return this.enforcing;
    }

    public boolean shouldLoad() {
        return true;
    }

    public static double getConverterEfficiency() {
        return MathHelper.func_151237_a((double)(1.0 - (double)CONVERTERLOSS.getValue() / 100.0), (double)0.0, (double)1.0);
    }

    public static boolean enableConverters() {
        return ConfigRegistry.getConverterEfficiency() > 0.0;
    }

    public static int getRecipeModifyPower() {
        if (RECIPEMOD.getState()) {
            if (STRONGRECIPEMOD.getState()) {
                String s = CORERECIPEMOD.getString();
                if (ConfigRegistry.isValidRecipeModString(s)) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static boolean isValidRecipeModString(String s) {
        return false;
    }

    public String getCustomConfigFile() {
        switch (this) {
            case STRONGRECIPEMOD: 
            case CORERECIPEMOD: {
                return "*_RecipeModding";
            }
        }
        return null;
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean saveIfUnspecified() {
        switch (this) {
            case STRONGRECIPEMOD: 
            case CORERECIPEMOD: {
                return false;
            }
        }
        return true;
    }

    public static float getBorerPowerMult() {
        return MathHelper.func_76131_a((float)BORERPOW.getFloat(), (float)0.5f, (float)8.0f);
    }

    public static boolean enableFermenterYeast() {
        return BEEYEAST.getValue() <= 1;
    }

    public static boolean enableBeeYeast() {
        return BEEYEAST.getValue() >= 1;
    }

    public static float getSmelteryFlakeYield() {
        return MathHelper.func_76131_a((float)TINKERFLAKES.getFloat(), (float)0.25f, (float)2.0f);
    }

    public static float getFreeWaterProduction() {
        return MathHelper.func_76131_a((float)FREEWATER.getFloat(), (float)0.1f, (float)2.0f);
    }

    public boolean enforceMatch() {
        switch (this) {
            case STRONGRECIPEMOD: 
            case CORERECIPEMOD: 
            case GPRORES: 
            case CRAFTABLEBEDROCK: 
            case MODORES: 
            case DIFFICULTY: 
            case TABLEMACHINES: 
            case ROTATEHOSE: 
            case HSLADICT: 
            case PREENCHANT: 
            case ALLOWTNTCANNON: 
            case ALLOWEMP: 
            case NOMINERS: 
            case PIPEHARDNESS: 
            case CONVERTERLOSS: 
            case ALLOWLIGHTBRIDGE: 
            case ALLOWITEMCANNON: 
            case ALLOWCHUNKLOADER: 
            case RECIPEMOD: 
            case LATEDYNAMO: 
            case BORERPOW: 
            case BEEYEAST: {
                return true;
            }
        }
        return false;
    }

    public boolean isUserSpecific() {
        switch (this) {
            case ENGINEVOLUME: 
            case MACHINEVOLUME: 
            case PROJECTORLINES: 
            case DYNAMICHANDBOOK: 
            case COLORBLIND: 
            case SPRINKLER: 
            case CLEARCHAT: 
            case POWERCLIENT: {
                return true;
            }
        }
        return false;
    }

    static {
        optionList = ConfigRegistry.values();
    }
}

