/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools;

import Reika.DragonAPI.Interfaces.Item.SpriteRenderCallback;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Base.ItemRotaryTool;
import Reika.RotaryCraft.Registry.GuiRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ItemCraftPattern
extends ItemRotaryTool
implements SpriteRenderCallback {
    public ItemCraftPattern(int index) {
        super(index);
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            is.field_77990_d = null;
        } else {
            ep.openGui((Object)RotaryCraft.instance, GuiRegistry.PATTERN.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean par4) {
        if (is.field_77990_d == null) {
            li.add("No Crafting Pattern.");
        } else {
            ItemStack item = ItemCraftPattern.getRecipeOutput(is);
            if (item != null) {
                li.add("Crafts " + item.field_77994_a + " " + item.func_82833_r());
            } else {
                li.add("Items, No Output.");
            }
        }
        li.add("Recipe Mode: " + ItemCraftPattern.getMode((ItemStack)is).displayName);
    }

    public static ItemStack getRecipeOutput(ItemStack is) {
        ItemStack item = is.field_77990_d != null ? ItemStack.func_77949_a((NBTTagCompound)is.field_77990_d.func_74775_l("output")) : null;
        return item != null ? item.func_77946_l() : null;
    }

    public static ItemStack[] getItems(ItemStack is) {
        ItemStack[] items = new ItemStack[9];
        if (is.field_77990_d != null) {
            NBTTagCompound recipe = is.field_77990_d.func_74775_l("recipe");
            for (int i = 0; i < 9; ++i) {
                String s = "slot" + i;
                if (!recipe.func_74764_b(s)) continue;
                NBTTagCompound tag = recipe.func_74775_l(s);
                ItemStack in = ItemStack.func_77949_a((NBTTagCompound)tag);
                if (in == null && tag != null && !tag.func_82582_d()) {
                    is.field_77990_d = null;
                    return null;
                }
                items[i] = in;
            }
        }
        return items;
    }

    public static int getStackInputLimit(ItemStack is) {
        if (is.field_77990_d != null) {
            int amt = is.field_77990_d.func_74762_e("stacklimit");
            return amt > 0 ? amt : 64;
        }
        return 64;
    }

    private static void resetNBT(ItemStack is) {
        if (is.field_77990_d != null) {
            is.field_77990_d.func_82580_o("output");
            is.field_77990_d.func_82580_o("recipe");
        }
    }

    public static void setRecipe(ItemStack is, InventoryCrafting ic, World world) {
        ItemStack out;
        ItemCraftPattern.resetNBT(is);
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        boolean valid = (out = ItemCraftPattern.getMode(is).getRecipe(ic, world)) != null;
        NBTTagCompound recipe = new NBTTagCompound();
        for (int i = 0; i < 9; ++i) {
            ItemStack in = ic.func_70301_a(i);
            if (in == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            in.func_77955_b(tag);
            recipe.func_74782_a("slot" + i, (NBTBase)tag);
        }
        is.field_77990_d.func_74782_a("recipe", (NBTBase)recipe);
        is.field_77990_d.func_74757_a("valid", valid);
        if (valid) {
            NBTTagCompound outt = new NBTTagCompound();
            out.func_77955_b(outt);
            is.field_77990_d.func_74782_a("output", (NBTBase)outt);
        }
    }

    public boolean onRender(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY && Keyboard.isKeyDown((int)42)) {
            ItemStack out = ItemCraftPattern.getRecipeOutput(is);
            if (out != null) {
                double s = 0.0625;
                GL11.glScaled((double)s, (double)(-s), (double)s);
                ReikaGuiAPI.instance.drawItemStack(ri, out, 0, -16);
                return true;
            }
        }
        return false;
    }

    public boolean doPreGLTransforms(ItemStack is, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public static RecipeMode getMode(ItemStack is) {
        return is.field_77990_d != null ? RecipeMode.list[is.field_77990_d.func_74762_e("mode")] : RecipeMode.CRAFTING;
    }

    public static void setMode(ItemStack is, RecipeMode md) {
        if (!ItemRegistry.CRAFTPATTERN.matchItem(is)) {
            return;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("mode", md.ordinal());
    }

    public static void changeStackLimit(ItemStack is, int change) {
        if (!ItemRegistry.CRAFTPATTERN.matchItem(is)) {
            return;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        int limit = ItemCraftPattern.getStackInputLimit(is);
        is.field_77990_d.func_74768_a("stacklimit", MathHelper.func_76125_a((int)(limit + change), (int)1, (int)64));
    }

    public static boolean checkPatternForMatch(IInventory te, RecipeMode type, int invslot, int patternslot, ItemStack is, ItemStack p) {
        ItemStack in = te.func_70301_a(invslot);
        return ItemCraftPattern.getMode(p) == type && ItemCraftPattern.checkItemAndSize(patternslot, is, p, in != null ? in.field_77994_a : 0);
    }

    private static boolean checkItemAndSize(int slot, ItemStack is, ItemStack p, int current) {
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemCraftPattern.getItems(p)[slot]) && current + is.field_77994_a <= Math.min(is.func_77976_d(), ItemCraftPattern.getStackInputLimit(p));
    }

    public static enum RecipeMode {
        CRAFTING("Crafting Recipe", new ItemStack(Blocks.field_150462_ai)),
        WORKTABLE("Worktable Recipe", MachineRegistry.WORKTABLE.getCraftedProduct()),
        BLASTFURN("Blast Furnace Crafting", MachineRegistry.BLASTFURNACE.getCraftedProduct());

        private final ItemStack item;
        public final String displayName;
        public static final RecipeMode[] list;

        private RecipeMode(String s, ItemStack is) {
            this.item = is;
            this.displayName = s;
        }

        public ItemStack getIcon() {
            return this.item.func_77946_l();
        }

        public RecipeMode next() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        public ItemStack getRecipe(InventoryCrafting ic, World world) {
            switch (this) {
                case CRAFTING: {
                    List li = CraftingManager.func_77594_a().func_77592_b();
                    for (IRecipe ir : li) {
                        if (!ir.func_77569_a(ic, null)) continue;
                        return ir.func_77571_b();
                    }
                    return null;
                }
                case BLASTFURN: {
                    for (RecipesBlastFurnace.BlastCrafting ir : RecipesBlastFurnace.getRecipes().getAllCraftingRecipes()) {
                        if (!ir.matches(ic, Integer.MAX_VALUE)) continue;
                        return ir.outputItem();
                    }
                    return null;
                }
                case WORKTABLE: {
                    WorktableRecipes.WorktableRecipe wr = WorktableRecipes.getInstance().findMatchingRecipe(ic, null);
                    return wr != null ? wr.getOutput() : null;
                }
            }
            return null;
        }

        static {
            list = RecipeMode.values();
        }
    }
}

