/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Entities;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.TileEntities.World.TileEntitySonicBorer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntitySonicShot
extends EntityFireball {
    private final TileEntitySonicBorer te;

    public EntitySonicShot(World par1World) {
        super(par1World);
        this.te = null;
    }

    public EntitySonicShot(World world, TileEntitySonicBorer tile, String player) {
        super(world, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 0.0, 0.0, 0.0);
        this.te = tile;
        this.func_70107_b((double)tile.field_145851_c + 0.5 + (double)tile.xstep, (double)tile.field_145848_d + 0.5 + (double)tile.ystep, (double)tile.field_145849_e + 0.5 + (double)tile.zstep);
        double dd = 2.0;
        this.field_70159_w = (double)tile.xstep * dd;
        this.field_70181_x = (double)tile.ystep * dd;
        this.field_70179_y = (double)tile.zstep * dd;
        this.field_70232_b = this.field_70159_w;
        this.field_70233_c = this.field_70181_x;
        this.field_70230_d = this.field_70179_y;
        if (!world.field_72995_K) {
            this.field_70133_I = true;
        }
    }

    public int[] getSteps() {
        int[] steps = new int[3];
        if (this.field_70159_w != 0.0) {
            int n = steps[0] = this.field_70159_w > 0.0 ? 1 : -1;
        }
        if (this.field_70181_x != 0.0) {
            int n = steps[1] = this.field_70181_x > 0.0 ? 1 : -1;
        }
        if (this.field_70179_y != 0.0) {
            steps[2] = this.field_70179_y > 0.0 ? 1 : -1;
        }
        return steps;
    }

    protected void func_70227_a(MovingObjectPosition mov) {
        World world = this.field_70170_p;
        if (mov != null) {
            int x = mov.field_72311_b;
            int y = mov.field_72312_c;
            int z = mov.field_72309_d;
            this.breakBlocks(world, x, y, z);
            this.hurtMobs(world, x, y, z);
            this.func_70106_y();
        }
    }

    private void hurtMobs(World world, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(3.0, 3.0, 3.0);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            e.func_70097_a(DamageSource.field_76368_d, 1.0f);
        }
    }

    public void func_70071_h_() {
        int dz;
        int dy;
        int dx;
        int r;
        int z;
        int y;
        int x;
        int d;
        this.func_70030_z();
        ++this.field_70173_aa;
        if (this.field_70173_aa > 1200) {
            this.func_70106_y();
            return;
        }
        if (this.te != null && (d = this.te.xstep * ((x = (int)Math.floor(this.field_70165_t)) - this.te.field_145851_c) + this.te.ystep * ((y = (int)Math.floor(this.field_70163_u)) - this.te.field_145848_d) + this.te.zstep * ((z = (int)Math.floor(this.field_70161_v)) - this.te.field_145849_e)) >= (r = this.getRange())) {
            Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            int[] tg = this.te.getTargetPosn();
            MovingObjectPosition mov = new MovingObjectPosition(tg[0], tg[1], tg[2], -1, vec);
            this.func_70227_a(mov);
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (this.te != null) {
            int r2 = 3;
            dx = this.te.xstep == 0 ? r2 : 0;
            dy = this.te.ystep == 0 ? r2 : 0;
            dz = this.te.zstep == 0 ? r2 : 0;
        } else {
            dz = 2;
            dy = 2;
            dx = 2;
            AxisAlignedBB box = this.func_70046_E().func_72314_b((double)dx, (double)dy, (double)dz);
            List li = this.field_70170_p.func_72872_a(Entity.class, box);
            for (int i = 0; i < li.size(); ++i) {
                Entity e = (Entity)li.get(i);
                this.func_70108_f(e);
            }
        }
    }

    private int getRange() {
        return this.te.getDistanceToSurface();
    }

    public final boolean func_90999_ad() {
        return false;
    }

    public final AxisAlignedBB func_70046_E() {
        return AxisAlignedBB.func_72330_a((double)(this.field_70165_t + 0.4), (double)(this.field_70163_u + 0.4), (double)(this.field_70161_v + 0.4), (double)(this.field_70165_t + 0.6), (double)(this.field_70163_u + 0.6), (double)(this.field_70161_v + 0.6));
    }

    private void breakBlocks(World world, int x, int y, int z) {
        int k = 3;
        if (!world.field_72995_K) {
            if (this.te.xstep != 0) {
                for (int i = z - k; i <= z + k; ++i) {
                    for (int j = y - k; j <= y + k; ++j) {
                        this.dropBlockAt(world, x, j, i);
                    }
                }
            } else if (this.te.zstep != 0) {
                for (int i = x - k; i <= x + k; ++i) {
                    for (int j = y - k; j <= y + k; ++j) {
                        this.dropBlockAt(world, i, j, z);
                    }
                }
            } else if (this.te.ystep != 0) {
                for (int i = x - k; i <= x + k; ++i) {
                    for (int j = z - k; j <= z + k; ++j) {
                        this.dropBlockAt(world, i, y, j);
                    }
                }
            }
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode");
        ReikaParticleHelper.EXPLODE.spawnAt(world, (double)x, (double)y, (double)z);
    }

    private void dropBlockAt(World world, int x, int y, int z) {
        if (y == 0) {
            return;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (!world.field_72995_K && !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)x, (int)y, (int)z, (Block)b, (int)meta, (EntityPlayerMP)this.te.getServerPlacer())) {
            return;
        }
        if (!TileEntitySonicBorer.canDrop(world, x, y, z) && !(b instanceof BlockLiquid)) {
            return;
        }
        ArrayList li = b.getDrops(world, x, y, z, meta, 0);
        if (b == Blocks.field_150474_ac) {
            ItemStack is = ItemRegistry.SPAWNER.getStackOf();
            TileEntityMobSpawner te = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
            ReikaSpawnerHelper.addMobNBTToItem((ItemStack)is, (TileEntityMobSpawner)te);
            li.add(is);
        }
        ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)li);
        world.func_147468_f(x, y, z);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity e) {
        e.field_70159_w = this.field_70159_w;
        e.field_70181_x = this.field_70181_x;
        e.field_70179_y = this.field_70179_y;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

