/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicCropHandler;
import Reika.DragonAPI.ModList;
import Reika.GeoStrata.Registry.GeoBlocks;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesLavaMaker
extends RecipeHandler
implements RecipeInterface.RockMelterManager {
    private static final RecipesLavaMaker recipes = new RecipesLavaMaker();
    private final ItemHashMap<MeltingRecipe> recipeList = new ItemHashMap();

    public static final RecipesLavaMaker getRecipes() {
        return recipes;
    }

    private RecipesLavaMaker() {
        super(MachineRegistry.LAVAMAKER);
        RecipeInterface.rockmelt = this;
        this.addRecipe(Blocks.field_150348_b, FluidRegistry.LAVA, 1000, 1000, 5200000L, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(Blocks.field_150347_e, FluidRegistry.LAVA, 500, 1000, 3120000L, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(Blocks.field_150424_aL, FluidRegistry.LAVA, 2000, 600, 480000L, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(Blocks.field_150417_aV, FluidRegistry.LAVA, 1000, 1200, 4160000L, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe("stone", FluidRegistry.LAVA, 1000, 1000, 5200000L, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe("cobblestone", FluidRegistry.LAVA, 500, 1000, 2820000L, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(ItemRegistry.ETHANOL.getStackOf(), "rc ethanol", 1000, 180, 6000L, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemStacks.cleansludge, "rc ethanol", 1000, 180, 36000L, RecipeHandler.RecipeLevel.CORE);
    }

    private void addRecipe(String in, String out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        if (this.validateFluid(out)) {
            ArrayList li = OreDictionary.getOres((String)in);
            for (int i = 0; i < li.size(); ++i) {
                this.addRecipe((ItemStack)li.get(i), new FluidStack(FluidRegistry.getFluid((String)out), amt), temperature, energy, rl);
            }
        }
    }

    private void addRecipe(String in, Fluid out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        ArrayList li = OreDictionary.getOres((String)in);
        for (ItemStack sin : li) {
            if (this.recipeList.containsKey(sin)) continue;
            this.addRecipe(sin, new FluidStack(out, amt), temperature, energy, rl);
        }
    }

    private void addRecipe(ItemStack in, String out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        if (this.validateFluid(out)) {
            this.addRecipe(in, new FluidStack(FluidRegistry.getFluid((String)out), amt), temperature, energy, rl);
        }
    }

    private void addRecipe(Item in, String out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        if (this.validateFluid(out)) {
            this.addRecipe(new ItemStack(in), new FluidStack(FluidRegistry.getFluid((String)out), amt), temperature, energy, rl);
        }
    }

    private void addRecipe(Block in, String out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        if (this.validateFluid(out)) {
            this.addRecipe(new ItemStack(in), new FluidStack(FluidRegistry.getFluid((String)out), amt), temperature, energy, rl);
        }
    }

    private void addRecipe(Block in, Fluid out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(new ItemStack(in), new FluidStack(out, amt), temperature, energy, rl);
    }

    private void addRecipe(Item in, Fluid out, int amt, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(new ItemStack(in), new FluidStack(out, amt), temperature, energy, rl);
    }

    @Override
    public void addAPIRecipe(ItemStack in, FluidStack out, int temperature, long energy) {
        this.addRecipe(in, out, temperature, energy, RecipeHandler.RecipeLevel.API);
    }

    private void addRecipe(Block in, FluidStack out, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(new ItemStack(in), out, temperature, energy, rl);
    }

    private void addRecipe(Item in, FluidStack out, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(new ItemStack(in), out, temperature, energy, rl);
    }

    private void addRecipe(ItemStack in, FluidStack out, int temperature, long energy, RecipeHandler.RecipeLevel rl) {
        if (in != null) {
            MeltingRecipe rec = new MeltingRecipe(in, out, temperature, energy);
            this.recipeList.put(in, (Object)rec);
            this.onAddRecipe(rec, rl);
        } else {
            RotaryCraft.logger.logError((Object)("Null itemstack for recipe for " + out + "!"));
        }
    }

    private boolean validateFluid(String s) {
        return FluidRegistry.getFluid((String)s) != null;
    }

    public FluidStack getMelting(ItemStack is) {
        MeltingRecipe r = (MeltingRecipe)this.recipeList.get(is);
        return r != null ? r.output.copy() : null;
    }

    public int getMeltTemperature(ItemStack is) {
        MeltingRecipe r = (MeltingRecipe)this.recipeList.get(is);
        return r != null ? r.temperature : Integer.MIN_VALUE;
    }

    public long getMeltingEnergy(ItemStack is) {
        MeltingRecipe r = (MeltingRecipe)this.recipeList.get(is);
        return r != null ? r.requiredEnergy : Integer.MIN_VALUE;
    }

    public boolean isValidFuel(ItemStack is) {
        return this.recipeList.containsKey(is);
    }

    public ArrayList<ItemStack> getSourceItems(Fluid f) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack key : this.recipeList.keySet()) {
            MeltingRecipe r = (MeltingRecipe)this.recipeList.get(key);
            if (!r.output.getFluid().equals(f)) continue;
            li.add(key.func_77946_l());
        }
        return li;
    }

    public Collection<ItemStack> getAllRecipes() {
        return Collections.unmodifiableCollection(this.recipeList.keySet());
    }

    @Override
    public void addPostLoadRecipes() {
        this.addRecipe("dustGlowstone", "glowstone", 250, 400, 80000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe(Blocks.field_150426_aN, "glowstone", 1000, 500, 320000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe("dustRedstone", "redstone", 100, 600, 120000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe(Blocks.field_150451_bX, "redstone", 900, 750, 1080000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe(Items.field_151079_bi, "ender", 250, 400, 240000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe("blockEnder", "ender", 1000, 400, 240000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe("dustCoal", "coal", 100, 300, 60000L, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe(ItemStacks.dryice, "rc co2", 200, 0, 6000L, RecipeHandler.RecipeLevel.PERIPHERAL);
        if (ModList.THERMALFOUNDATION.isLoaded()) {
            ItemStack pyro = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"dustPyrotheum", (int)1);
            this.addRecipe(pyro, "pyrotheum", 250, 1800, 9000000L, RecipeHandler.RecipeLevel.MODINTERACT);
            ItemStack cryo = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"dustCryotheum", (int)1);
            this.addRecipe(cryo, "cryotheum", 250, -200, 2000L, RecipeHandler.RecipeLevel.MODINTERACT);
            ItemStack petro = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"dustPetrotheum", (int)1);
            this.addRecipe(petro, "petrotheum", 250, 800, 12000000L, RecipeHandler.RecipeLevel.MODINTERACT);
            ItemStack aero = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"dustAerotheum", (int)1);
            this.addRecipe(aero, "aerotheum", 250, 400, 40000L, RecipeHandler.RecipeLevel.MODINTERACT);
        }
        this.addRecipe("shardCrystal", "potion crystal", 8000, 500, 80000L, RecipeHandler.RecipeLevel.MODINTERACT);
        if (ModList.MAGICCROPS.isLoaded() && MagicCropHandler.EssenceType.XP.getEssence() != null) {
            this.addRecipe(MagicCropHandler.EssenceType.XP.getEssence(), "mobessence", 200, 600, 360000L, RecipeHandler.RecipeLevel.MODINTERACT);
        }
        if (ModList.GEOSTRATA.isLoaded()) {
            this.addLavaRock();
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.GEOSTRATA)
    private void addLavaRock() {
        for (int i = 0; i < 4; ++i) {
            ItemStack is = new ItemStack(GeoBlocks.LAVAROCK.getBlockInstance(), 1, i);
            this.addRecipe(is, new FluidStack(FluidRegistry.LAVA, 1000), 900 - 200 * i, 5200000L / (long)(i + 1), RecipeHandler.RecipeLevel.MODINTERACT);
        }
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipeList.removeValue((Object)((MeltingRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack in = crl.parseItemString(lb.getString("input"), null, false);
        LuaBlock fluid = lb.getChild("output_fluid");
        String s = fluid.getString("type");
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f == null) {
            throw new IllegalArgumentException("Fluid '" + s + "' does not exist!");
        }
        this.verifyOutputFluid(f);
        FluidStack fs = new FluidStack(f, fluid.getInt("amount"));
        int temp = lb.getInt("temperature");
        long energy = lb.getLong("energy");
        this.addRecipe(in, fs, temp, energy, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    private static class MeltingRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack input;
        private final FluidStack output;
        private final int temperature;
        private final long requiredEnergy;

        private MeltingRecipe(ItemStack is, FluidStack fs, int t, long e) {
            this.input = is;
            this.output = fs;
            this.temperature = t;
            this.requiredEnergy = e;
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.input) + "@" + this.temperature + "#" + this.output.getFluid().getName() + ":" + this.output.amount;
        }

        @Override
        public String getAllInfo() {
            return "Melting " + RecipeHandler.fullID(this.input) + "into " + this.output.amount + " of " + this.output.getLocalizedName() + " @ " + this.temperature + "C using " + this.requiredEnergy + " J";
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object)this.input);
        }
    }
}

