/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.PowerTracker;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import java.util.HashSet;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerSourceList
implements PowerTracker {
    private HashSet<PowerWrapper> engines = new HashSet();
    private HashSet<ShaftMerger> mergers = new HashSet();
    private ShaftMerger caller;
    private boolean isLooping = false;
    private boolean isBedrock = false;
    private boolean errored = false;

    @Override
    public long getMaxGennablePower() {
        long pwr = 0L;
        for (PowerWrapper eng : this.engines) {
            pwr += eng.generator.getMaxPower();
        }
        return pwr;
    }

    @Override
    public long getRealMaxPower() {
        long pwr = 0L;
        for (PowerWrapper eng : this.engines) {
            pwr += eng.generator.getCurrentPower();
        }
        return pwr;
    }

    public PowerSourceList addSource(PowerGenerator te) {
        this.engines.add(new PowerWrapper(te));
        return this;
    }

    @Override
    public boolean isLooping() {
        return this.isLooping;
    }

    public static PowerSourceList getAllFrom(World world, ForgeDirection dir, int x, int y, int z, PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList pwr = new PowerSourceList();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (caller != null && (pwr.passesThrough(caller) || tile instanceof ShaftMerger && pwr.passesThrough((ShaftMerger)tile) || tile == caller)) {
            pwr.isLooping = true;
            caller.onPowerLooped(pwr);
            return pwr;
        }
        if (tile instanceof ShaftMerger) {
            pwr.mergers.add((ShaftMerger)tile);
            if (tile == caller) {
                pwr.isLooping = true;
            }
            pwr.isBedrock = tile instanceof TileEntitySplitter && ((TileEntitySplitter)tile).isBedrock();
        }
        if (pwr.errored) {
            PowerSourceList.fail(pwr, caller, world, x, y, z);
        }
        try {
            WorldLocation loc;
            if (tile instanceof TileEntityIOMachine) {
                TileEntityIOMachine te = (TileEntityIOMachine)tile;
                if (!te.isWritingTo(io) && !te.isWritingTo2(io)) {
                    return pwr;
                }
                if (te.isReadingFrom(io) || te.isReadingFrom2(io) || te.isReadingFrom3(io) || te.isReadingFrom4(io)) {
                    return pwr;
                }
                pwr.addAll(te.getPowerSources(io, caller));
            } else if (tile instanceof PowerSourceTracker) {
                pwr.addAll(((PowerSourceTracker)tile).getPowerSources(io, caller));
            } else if (tile instanceof PowerGenerator) {
                pwr.addSource((PowerGenerator)tile);
            } else if (tile instanceof WorldRift && (loc = ((WorldRift)tile).getLinkTarget()) != null) {
                int dx = loc.xCoord + dir.offsetX;
                int dy = loc.yCoord + dir.offsetY;
                int dz = loc.zCoord + dir.offsetZ;
                return PowerSourceList.getAllFrom(world, dir, dx, dy, dz, io, caller);
            }
            pwr.caller = caller;
            if (pwr.passesThrough(caller)) {
                pwr.isLooping = true;
            }
            return pwr;
        }
        catch (StackOverflowError e) {
            RotaryCraft.logger.logError((Object)("PowerSourceList SOE @ " + pwr + ", called from " + caller + "!"));
            pwr.errored = true;
            return pwr;
        }
    }

    private static void fail(PowerSourceList pwr, ShaftMerger caller, World world, int x, int y, int z) {
        if (caller != null) {
            caller.fail();
        } else {
            try {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void addAll(PowerSourceList pwr) {
        for (PowerWrapper te : pwr.engines) {
            this.addSource(te.generator);
        }
        this.errored = this.errored || pwr.errored;
    }

    public String toString() {
        if (this.engines.isEmpty()) {
            return "[None]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (PowerWrapper gen : this.engines) {
            sb.append(gen.generator);
        }
        return sb.toString();
    }

    @Override
    public boolean contains(PowerGenerator te) {
        return this.engines.contains(new PowerWrapper(te));
    }

    @Override
    public boolean calledFrom(ShaftMerger sm) {
        return this.caller == sm;
    }

    @Override
    public boolean passesThrough(ShaftMerger sm) {
        return this.mergers.contains(sm);
    }

    @Override
    public boolean isEngineSpam() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.isBedrock()) {
            return false;
        }
        long sum = this.getMaxGennablePower();
        long avg = sum / (long)this.engines.size();
        return avg > 0L && sum / avg > 4L;
    }

    public int size() {
        return this.engines.size();
    }

    public boolean isEmpty() {
        return this.engines.isEmpty();
    }

    public boolean isBedrock() {
        return this.isBedrock;
    }

    public static PowerSourceList combine(PowerSourceList in1, PowerSourceList in2, ShaftMerger caller) {
        PowerSourceList psl = new PowerSourceList();
        psl.engines.addAll(in1.engines);
        psl.engines.addAll(in2.engines);
        psl.mergers.addAll(in1.mergers);
        psl.mergers.addAll(in2.mergers);
        if (psl.mergers.contains(caller)) {
            psl.isLooping = true;
        }
        psl.caller = caller;
        return psl;
    }

    private static class PowerWrapper {
        private final PowerGenerator generator;

        private PowerWrapper(PowerGenerator gen) {
            this.generator = gen;
        }

        public int hashCode() {
            return new WorldLocation((TileEntity)this.generator).hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof PowerWrapper && new WorldLocation((TileEntity)((PowerWrapper)o).generator).equals((Object)new WorldLocation((TileEntity)this.generator));
        }
    }
}

