/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.util.helpers;

import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import theflogat.technomancy.common.items.base.TMItems;

public class WorldHelper {
    public static boolean destroyAndDrop(World w, int x, int y, int z) {
        Block block = w.func_147439_a(x, y, z);
        if (block != null && block.func_149712_f(w, x, y, z) >= 0.0f) {
            if (!w.field_72995_K) {
                block.func_149749_a(w, x, y, z, block, w.func_72805_g(x, y, z));
                ArrayList d = block.getDrops(w, x, y, z, w.func_72805_g(x, y, z), 0);
                for (ItemStack s : d) {
                    WorldHelper.spawnEntItem(w, x, y, z, s);
                }
            }
            w.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public static void spawnEntItem(World w, double x, double y, double z, ItemStack items) {
        if (items != null && items.field_77994_a > 0) {
            float rx = w.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float ry = w.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float rz = w.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(w, x + (double)rx, y + (double)ry, z + (double)rz, new ItemStack(items.func_77973_b(), items.field_77994_a, items.func_77960_j()));
            if (items.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)items.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = w.field_73012_v.nextGaussian() * (double)factor;
            entityItem.field_70181_x = w.field_73012_v.nextGaussian() * (double)factor + 0.2000000029802322;
            entityItem.field_70179_y = w.field_73012_v.nextGaussian() * (double)factor;
            w.func_72838_d((Entity)entityItem);
        }
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tile, byte facing) {
        if (tile == null || tile.func_145831_w() == null) {
            return null;
        }
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[facing % ForgeDirection.VALID_DIRECTIONS.length];
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tile, ForgeDirection dir) {
        if (tile == null || tile.func_145831_w() == null && dir == null) {
            return null;
        }
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
    }

    public static boolean isEnergyHandlerFromOppFacing(TileEntity tile, byte facing) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[facing % ForgeDirection.VALID_DIRECTIONS.length];
        return tile instanceof IEnergyHandler ? ((IEnergyHandler)tile).canConnectEnergy(dir.getOpposite()) : false;
    }

    public static int insertFluidIntoAdjacentFluidHandler(TileEntity tile, int side, FluidStack fluid, boolean doFill) {
        TileEntity handler = WorldHelper.getAdjacentTileEntity(tile, (byte)side);
        return handler instanceof IFluidHandler ? ((IFluidHandler)handler).fill(ForgeDirection.VALID_DIRECTIONS[side ^ 1], fluid, doFill) : 0;
    }

    public static boolean isAdjacentFluidHandler(TileEntity entity, byte i) {
        return WorldHelper.getAdjacentTileEntity(entity, i) != null && WorldHelper.getAdjacentTileEntity(entity, i) instanceof IFluidHandler;
    }

    public static void dropBoost(World w, int x, int y, int z) {
        WorldHelper.spawnEntItem(w, x, y, z, new ItemStack(TMItems.itemBoost, 1));
    }

    public static boolean isChunkLoaded(World w, int x, int z) {
        return w.func_72938_d((int)x, (int)z).field_76636_d;
    }

    public static boolean isPlayerProbablyCollidingWithBlock(EntityPlayer player, int x, int y, int z) {
        return Math.floor(player.field_70165_t) - 1.0 > (double)x && Math.ceil(player.field_70165_t) < (double)x && Math.floor(player.field_70163_u) - 1.0 > (double)y && Math.ceil(player.field_70163_u) < (double)y && Math.floor(player.field_70161_v) - 1.0 > (double)z && Math.ceil(player.field_70161_v) < (double)z;
    }
}

