/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.util;

import cpw.mods.fml.common.Loader;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class Ore {
    public static final ArrayList<Ore> ores = new ArrayList();
    public static final ArrayList<String> oreNames = new ArrayList();
    private final String oreName;
    private String name;
    private final ItemStack ingot;
    private Item pureItem;
    private Color color = Color.WHITE;
    private boolean state;
    private int[] ingotsPerStage = new int[]{2, 3, 4, 5, 6, 7};

    public static Ore newOre(String dictName, ItemStack ingot, String name) {
        oreNames.add(dictName);
        return new Ore(dictName, ingot, name);
    }

    public static void init() {
        Ore.getMetalsWithPrefixes("ore", "ingot");
    }

    private static void getMetalsWithPrefixes(String prefix1, String prefix2) {
        block0: for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith(prefix1) || OreDictionary.getOres((String)name).isEmpty()) continue;
            String oreName = name.substring(prefix1.length());
            for (String n : OreDictionary.getOreNames()) {
                if (!n.equals(prefix2 + oreName) || OreDictionary.getOres((String)n).isEmpty()) continue;
                for (ItemStack ore : OreDictionary.getOres((String)name)) {
                    ItemStack testIngot = FurnaceRecipes.func_77602_a().func_151395_a(ore);
                    if (testIngot == null) continue;
                    for (ItemStack ingot : OreDictionary.getOres((String)n)) {
                        if (!testIngot.func_77969_a(ingot) || testIngot.func_77960_j() != ingot.func_77960_j()) continue;
                        Ore.newOre(name, testIngot, oreName);
                        continue block0;
                    }
                }
            }
        }
        if (oreNames.contains("oreAluminum") && oreNames.contains("oreAluminium")) {
            Iterator<Ore> oreIter = ores.iterator();
            while (oreIter.hasNext()) {
                Ore ore = oreIter.next();
                if (ore.oreName() != "oreAluminium") continue;
                oreIter.remove();
                oreNames.remove("oreAluminium");
                break;
            }
        }
    }

    private static String adjustName(String name) {
        if (name.equals("FzDarkIron")) {
            return "Dark Iron";
        }
        return name;
    }

    public static void initColors() {
        for (Ore ore : ores) {
            ore.setColor(Ore.getColor(ore.oreName().substring(3)));
        }
    }

    private static int getStackColor(ItemStack stack, int pass) {
        if (Loader.isModLoaded((String)"gregtech")) {
            try {
                Class<?> cls = Class.forName("gregtech.api.items.GT_MetaGenerated_Item");
                Class<?> itemCls = stack.func_77973_b().getClass();
                if (cls.isAssignableFrom(itemCls)) {
                    Method m = itemCls.getMethod("getRGBa", ItemStack.class);
                    short[] rgba = (short[])m.invoke((Object)stack.func_77973_b(), stack);
                    return new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack.func_77973_b().func_82790_a(stack, pass);
    }

    private static Color getColor(String oreName) {
        ArrayList ores = OreDictionary.getOres((String)("ingot" + oreName));
        if (ores.isEmpty()) {
            return null;
        }
        LinkedHashSet<Color> colors = new LinkedHashSet<Color>();
        for (ItemStack stack : ores) {
            try {
                BufferedImage texture = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(Ore.getIconResource(stack)).func_110527_b());
                Color texColour = Ore.getAverageColor(texture);
                colors.add(texColour);
                for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++pass) {
                    int c = Ore.getStackColor(stack, pass);
                    if (c == 0xFFFFFF) continue;
                    colors.add(new Color(c));
                    colors.remove(texColour);
                }
            }
            catch (Exception e) {
            }
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (Color c : colors) {
            red += (float)c.getRed();
            green += (float)c.getGreen();
            blue += (float)c.getBlue();
        }
        float count = colors.size();
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static Color getAverageColor(BufferedImage image) {
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float count = 0.0f;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                Color c = new Color(image.getRGB(i, j));
                if (c.getAlpha() != 255 || c.getRed() <= 10 && c.getBlue() <= 10 && c.getGreen() <= 10) continue;
                red += (float)c.getRed();
                green += (float)c.getGreen();
                blue += (float)c.getBlue();
                count += 1.0f;
            }
        }
        return new Color((int)(red / count), (int)(green / count), (int)(blue / count));
    }

    private static String getIconName(ItemStack stack) {
        IIcon icon = stack.func_77973_b().func_77617_a(stack.func_77960_j());
        if (icon != null) {
            return icon.func_94215_i();
        }
        return null;
    }

    private static ResourceLocation getIconResource(ItemStack stack) {
        String iconName = Ore.getIconName(stack);
        if (iconName == null) {
            return null;
        }
        String string = "minecraft";
        int colonIndex = iconName.indexOf(58);
        if (colonIndex >= 0) {
            if (colonIndex > 1) {
                string = iconName.substring(0, colonIndex);
            }
            iconName = iconName.substring(colonIndex + 1, iconName.length());
        }
        string = string.toLowerCase();
        iconName = "textures/items/" + iconName + ".png";
        return new ResourceLocation(string, iconName);
    }

    public static boolean isProcessableOre(ItemStack items) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)items)) {
            if (!oreNames.contains(OreDictionary.getOreName((int)id))) continue;
            return true;
        }
        return false;
    }

    protected Ore(String oreName, ItemStack ingot, String name) {
        this.oreName = oreName;
        this.ingot = ingot;
        this.name = Ore.adjustName(name);
        ores.add(this);
    }

    public String oreName() {
        return this.oreName;
    }

    public String name() {
        return this.name;
    }

    public ItemStack ingot() {
        return this.ingot;
    }

    public int color() {
        return this.color.getRGB() & 0xFFFFFF;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPure(Item pure) {
        this.pureItem = pure;
    }

    public Item getPure() {
        return this.pureItem;
    }

    public int getIngotsPerStage(int stage) {
        return this.ingotsPerStage[stage];
    }

    public void setIngotsPerStage(List<String> nums) {
        for (int i = 0; i < this.ingotsPerStage.length; ++i) {
            this.ingotsPerStage[i] = Integer.parseInt(nums.get(i).trim());
        }
    }

    public int hashCode() {
        return this.oreName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Ore && this.oreName.equals(((Ore)obj).oreName);
    }

    public String toString() {
        return this.oreName();
    }

    public void setEnabled(boolean state) {
        this.state = state;
        if (!state) {
            oreNames.remove(this.oreName);
        }
    }

    public boolean getEnabled() {
        return this.state;
    }

    public void setName(String name) {
        this.name = name;
    }
}

