/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import theflogat.technomancy.common.player.PlayerData;
import theflogat.technomancy.util.Loc;

public class PacketHandler {
    public EnumMap<Side, FMLEmbeddedChannel> channels;
    public static PacketHandler instance;

    public PacketHandler() {
        instance = this;
        this.channels = NetworkRegistry.INSTANCE.newChannel("technom", new ChannelHandler[]{new TechnomChannelHandler()});
        if (Loc.isClient()) {
            FMLEmbeddedChannel channel = this.channels.get(Side.CLIENT);
            String handler = channel.findChannelHandlerNameForType(TechnomChannelHandler.class);
            channel.pipeline().addAfter(handler, "ExistenceStatsHandler", (ChannelHandler)new ExistenceStatsHandler());
        }
    }

    public static Packet getPacket(EntityPlayerMP player) {
        NBTTagCompound data = PlayerData.getData((EntityPlayer)player);
        ExistenceStats stats = new ExistenceStats();
        stats.id = 0;
        stats.exLevel = data.func_74762_e("existencelevel");
        stats.exPower = data.func_74762_e("existencepower");
        stats.affinities = new int[PlayerData.Affinity.allAff.length];
        for (int i = 0; i < PlayerData.Affinity.allAff.length; ++i) {
            stats.affinities[i] = data.func_74762_e(PlayerData.Affinity.allAff[i].getName());
        }
        return PacketHandler.instance.channels.get(Side.SERVER).generatePacketFrom((Object)stats);
    }

    public void sendTo(Packet message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAll(Packet message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(Packet message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public class TechnomChannelHandler
    extends FMLIndexedMessageToMessageCodec<BaseMessage> {
        public TechnomChannelHandler() {
            this.addDiscriminator(0, ExistenceStats.class);
        }

        public void encodeInto(ChannelHandlerContext ctx, BaseMessage msg, ByteBuf target) throws Exception {
            target.writeInt(msg.id);
            switch (msg.id) {
                case 0: {
                    target.writeInt(((ExistenceStats)msg).exLevel);
                    target.writeInt(((ExistenceStats)msg).exPower);
                    for (int i = 0; i < PlayerData.Affinity.allAff.length; ++i) {
                        target.writeInt(((ExistenceStats)msg).affinities[i]);
                    }
                    break;
                }
            }
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, BaseMessage msg) {
            switch (source.readInt()) {
                case 0: {
                    ((ExistenceStats)msg).exLevel = source.readInt();
                    ((ExistenceStats)msg).exPower = source.readInt();
                    ((ExistenceStats)msg).affinities = new int[PlayerData.Affinity.allAff.length];
                    for (int i = 0; i < PlayerData.Affinity.allAff.length; ++i) {
                        ((ExistenceStats)msg).affinities[i] = source.readInt();
                    }
                    break;
                }
            }
        }
    }

    public static class ExistenceStatsHandler
    extends SimpleChannelInboundHandler<ExistenceStats> {
        protected void channelRead0(ChannelHandlerContext ctx, ExistenceStats stats) throws Exception {
            NBTTagCompound data = PlayerData.getData((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            data.func_74768_a("existencelevel", stats.exLevel);
            data.func_74768_a("existencepower", stats.exPower);
            for (int i = 0; i < PlayerData.Affinity.allAff.length; ++i) {
                data.func_74768_a(PlayerData.Affinity.allAff[i].getName(), stats.affinities[i]);
            }
        }
    }

    public static class ExistenceStats
    extends BaseMessage {
        int exLevel;
        int exPower;
        int[] affinities;
    }

    public static class BaseMessage {
        int id;
    }
}

