/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.storage;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import theflogat.technomancy.common.tiles.base.TileTechnomancy;
import theflogat.technomancy.lib.compat.Thaumcraft;

public class TileEssentiaReservoir
extends TileTechnomancy
implements IEssentiaTransport,
IAspectContainer {
    private static final int maxAmount = 256;
    public Aspect suction;
    Aspect as = null;
    int amount = 0;

    public void func_145845_h() {
        if (this.as != null) {
            this.suction = this.as;
        }
        this.fill();
    }

    public void fill() {
        if (this.amount < 256) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity te = Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir);
                if (te == null) continue;
                IEssentiaTransport ic = (IEssentiaTransport)te;
                Aspect ta = ic.getEssentiaType(dir.getOpposite());
                if (ic.getEssentiaAmount(dir.getOpposite()) <= 0 || ic.getSuctionAmount(dir.getOpposite()) >= this.getSuctionAmount(null) || this.getSuctionAmount(null) < ic.getMinimumSuction()) continue;
                this.addToContainer(ta, ic.takeEssentia(ta, 1, dir.getOpposite()));
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        comp.func_74768_a("amount", this.amount);
        if (this.as != null) {
            comp.func_74778_a("as", this.as.getTag());
        }
        if (this.suction != null) {
            comp.func_74778_a("suction", this.suction.getTag());
        }
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        this.amount = comp.func_74762_e("amount");
        this.as = Aspect.getAspect((String)comp.func_74779_i("as"));
        this.suction = Aspect.getAspect((String)comp.func_74779_i("suction"));
    }

    public boolean isConnectable(ForgeDirection face) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return true;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return this.suction;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return 128;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.takeFromContainer(aspect, amount) ? 0 : amount;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.as;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.amount;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public AspectList getAspects() {
        if (this.as != null && this.amount > 0) {
            AspectList al = new AspectList();
            al.add(this.as, this.amount);
            return al;
        }
        return null;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return this.as == null || this.as == tag;
    }

    public int addToContainer(Aspect tag, int amt) {
        if (amt != 0 && (this.amount < 256 && tag == this.as || this.amount == 0)) {
            this.as = tag;
            int added = Math.min(amt, 256 - this.amount);
            this.amount += added;
            amt -= added;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return amt;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.as != null && tag == this.as && amount <= this.amount) {
            this.amount -= amount;
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.as != null && tag == this.as && amount <= this.amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return this.as != null && tag == this.as ? this.amount : 0;
    }
}

