/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import cpw.mods.fml.common.Optional;
import me.jezza.thaumicpipes.api.interfaces.IThaumicInput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import theflogat.technomancy.common.tiles.base.TileProcessorBase;
import theflogat.technomancy.lib.compat.Thaumcraft;

@Optional.Interface(iface="me.jezza.thaumicpipes.api.interfaces.IThaumicInput", modid="ThaumicPipes")
public class TileTCProcessor
extends TileProcessorBase
implements IAspectContainer,
IEssentiaTransport,
IThaumicInput {
    public int amount = 0;
    public int maxAmount = 64;

    public TileTCProcessor() {
        super(0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.perform();
    }

    @Override
    protected boolean getFuel(ItemStack items, int multiplier, int reprocess) {
        int cost = Math.max(1, multiplier + 2 * reprocess);
        if (cost > this.amount) {
            return false;
        }
        this.takeFromContainer(Aspect.FIRE, cost);
        return true;
    }

    protected void perform() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEssentiaTransport ic;
            Aspect ta;
            TileEntity te = Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir);
            if (te == null || (ta = (ic = (IEssentiaTransport)te).getEssentiaType(dir.getOpposite())) != Aspect.FIRE || ic.getEssentiaAmount(dir.getOpposite()) <= 0 || ic.getSuctionAmount(dir.getOpposite()) >= this.getSuctionAmount(null) || this.getSuctionAmount(null) < ic.getMinimumSuction()) continue;
            this.addToContainer(ta, ic.takeEssentia(ta, 1, dir.getOpposite()));
        }
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        compound.func_74777_a("Amount", (short)this.amount);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.amount = compound.func_74765_d("Amount");
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.amount > 0) {
            al.add(Aspect.FIRE, this.amount);
        }
        return al;
    }

    public int addToContainer(Aspect tag, int amount) {
        if ((amount != 0 || tag == Aspect.FIRE) && this.amount < this.maxAmount) {
            int added = Math.min(amount, this.maxAmount - this.amount);
            this.amount += added;
            amount -= added;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.amount >= amount && tag == Aspect.FIRE) {
            this.amount -= amount;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        if (this.doesContainerContain(ot)) {
            this.amount -= ot.getAmount(Aspect.FIRE);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return this.amount >= amt && tag == Aspect.FIRE;
    }

    public int containerContains(Aspect tag) {
        return tag == Aspect.FIRE ? this.amount : 0;
    }

    public boolean isConnectable(ForgeDirection face) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int getMinimumSuction() {
        return 128;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return tag == Aspect.FIRE && this.amount < this.maxAmount;
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return Aspect.FIRE;
    }

    public int getSuctionAmount(ForgeDirection face) {
        if (this.amount < this.maxAmount) {
            return 128;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.amount > 0 ? Aspect.FIRE : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        return ot.size() == 1 && ot.aspects.containsKey(Aspect.FIRE) && this.amount >= ot.getAmount(Aspect.FIRE);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

