/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import cpw.mods.fml.common.Optional;
import me.jezza.thaumicpipes.api.interfaces.IThaumicInput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.tiles.TileInfusionMatrix;
import theflogat.technomancy.common.tiles.base.TileTechnomancy;
import theflogat.technomancy.lib.compat.Thaumcraft;
import theflogat.technomancy.util.helpers.WorldHelper;

@Optional.Interface(iface="me.jezza.thaumicpipes.api.interfaces.IThaumicInput", modid="ThaumicPipes")
public class TileFluxLamp
extends TileTechnomancy
implements IAspectContainer,
IEssentiaTransport,
IFluidHandler,
IThaumicInput {
    int amount = 0;
    int maxAmount = 32;
    public FluidTank tank = new FluidTank(1000);
    Aspect aspectSuction;
    boolean stabilize = true;
    public boolean placed = false;
    int count;

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        compound.func_74757_a("Stabilize", this.stabilize);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        this.stabilize = compound.func_74767_n("Stabilize");
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        compound.func_74768_a("AspectAmount", this.amount);
        compound.func_74757_a("Placed", this.placed);
        this.tank.writeToNBT(compound);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        this.amount = compound.func_74762_e("AspectAmount");
        this.placed = compound.func_74767_n("Placed");
        this.tank = new FluidTank(1000);
        this.tank.readFromNBT(compound);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tile = null;
            if (!this.field_145850_b.field_72995_K && ++this.count % 10 == 0) {
                if (this.amount < this.maxAmount) {
                    this.fill();
                }
                tile = this.getMatrix();
            }
            if (tile == null) {
                return;
            }
            if (!((TileInfusionMatrix)tile).crafting) {
                this.stabilize = true;
            }
            if (((TileInfusionMatrix)tile).instability > 0 && this.stabilize) {
                for (int i = 0; i < 5 && this.amount >= 5 && this.tank.getCapacity() - this.tank.getFluidAmount() >= 200 && this.stabilize; ++i) {
                    this.takeFromContainer(Aspect.ORDER, 5);
                    --((TileInfusionMatrix)tile).instability;
                    this.tank.fill(FluidRegistry.getFluidStack((String)Thaumcraft.FLUXGOO.getName(), (int)200), true);
                }
                this.stabilize = false;
            }
        }
    }

    TileEntity getMatrix() {
        for (int yy = -5; yy < 5; ++yy) {
            for (int xx = -10; xx < 10; ++xx) {
                for (int zz = -10; zz < 10; ++zz) {
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz);
                    if (!(te instanceof TileInfusionMatrix)) continue;
                    return te;
                }
            }
        }
        return null;
    }

    void fill() {
        TileEntity te = Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UP);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.DOWN)) {
                return;
            }
            if (ic.getEssentiaAmount(ForgeDirection.DOWN) > 0 && ic.getEssentiaType(ForgeDirection.DOWN) == Aspect.ORDER && ic.getSuctionAmount(ForgeDirection.DOWN) < this.getSuctionAmount(ForgeDirection.UP) && this.getSuctionAmount(ForgeDirection.UP) >= ic.getMinimumSuction()) {
                this.addToContainer(Aspect.ORDER, ic.takeEssentia(Aspect.ORDER, 1, ForgeDirection.DOWN));
            }
        }
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.amount > 0) {
            al.add(Aspect.ORDER, this.amount);
        }
        return al;
    }

    public int addToContainer(Aspect tag, int amount) {
        if (amount == 0) {
            return amount;
        }
        if (this.amount < this.maxAmount && tag == Aspect.ORDER) {
            int added = Math.min(amount, this.maxAmount - this.amount);
            this.amount += added;
            amount -= added;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.amount >= amount && tag == Aspect.ORDER) {
            this.amount -= amount;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amt) {
        return this.amount >= amt && tag == Aspect.ORDER;
    }

    public boolean doesContainerContain(AspectList ot) {
        if (ot.size() > 1) {
            return false;
        }
        return ot.getAspects()[1] == Aspect.ORDER && this.amount >= ot.getAmount(Aspect.ORDER);
    }

    public int getMinimumSuction() {
        return 128;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public int containerContains(Aspect tag) {
        return tag == Aspect.ORDER ? this.amount : 0;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return tag == Aspect.ORDER && this.amount < this.maxAmount;
    }

    public boolean isConnectable(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public Aspect getSuctionType(ForgeDirection face) {
        if (this.amount < this.maxAmount) {
            return Aspect.ORDER;
        }
        return null;
    }

    public int getSuctionAmount(ForgeDirection loc) {
        if (this.amount < this.maxAmount) {
            return 128;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return amount - this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.amount > 0 ? Aspect.ORDER : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.amount;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidStack stack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)200);
        int f = WorldHelper.insertFluidIntoAdjacentFluidHandler(this, from.ordinal(), stack, false);
        return f == 200;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

