/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.dynamos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.INode;
import theflogat.technomancy.common.tiles.base.TileDynamoBase;

public class TileNodeDynamo
extends TileDynamoBase {
    public static final int maxAmount = 32;
    public int amount = 0;
    public boolean draining = false;
    public int sourceX;
    public int sourceY;
    public int sourceZ;
    public int color;
    private int counter = 0;

    @Override
    public int extractFuel(int ener) {
        float ratio = (float)ener / 80.0f;
        if (ratio > (float)this.amount) {
            return 0;
        }
        this.amount = (int)((double)this.amount - Math.ceil(ratio));
        return 30;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.counter++ == 20) {
            this.draining = false;
            if (this.amount < 32) {
                this.takeAspectsFromNodes();
            }
            this.counter = 0;
        }
    }

    public void takeAspectsFromNodes() {
        ArrayList<TileEntity> l = this.getNodes();
        if (!l.isEmpty()) {
            Collections.shuffle(l);
            for (TileEntity te : l) {
                if (te == null || !(te instanceof INode)) continue;
                INode node = (INode)te;
                Aspect[] as = node.getAspects().getAspects();
                Collections.shuffle(Arrays.asList(as));
                for (int i = 0; i < as.length; ++i) {
                    Aspect aspect = as[i];
                    if (node.getAspects().getAmount(aspect) <= 1 || this.amount >= 16 || !node.takeFromContainer(aspect, 1)) continue;
                    ++this.amount;
                    this.draining = true;
                    this.sourceX = te.field_145851_c;
                    this.sourceY = te.field_145848_d;
                    this.sourceZ = te.field_145849_e;
                    this.color = aspect.getColor();
                    return;
                }
            }
        }
    }

    public ArrayList<TileEntity> getNodes() {
        ArrayList<TileEntity> l = new ArrayList<TileEntity>();
        for (int xx = -4; xx <= 4; ++xx) {
            for (int yy = -4; yy <= 4; ++yy) {
                for (int zz = -4; zz <= 4; ++zz) {
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + xx, this.field_145848_d + yy, this.field_145849_e + zz);
                    if (!(te instanceof INode)) continue;
                    l.add(te);
                }
            }
        }
        return l;
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        comp.func_74777_a("Amount", (short)this.amount);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.amount = comp.func_74765_d("Amount");
    }
}

