/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.dynamos;

import cpw.mods.fml.common.Optional;
import java.util.Random;
import me.jezza.thaumicpipes.api.interfaces.IThaumicInput;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import theflogat.technomancy.common.tiles.base.TileDynamoBase;
import theflogat.technomancy.lib.compat.Thaumcraft;

@Optional.Interface(iface="me.jezza.thaumicpipes.api.interfaces.IThaumicInput", modid="ThaumicPipes")
public class TileEssentiaDynamo
extends TileDynamoBase
implements IAspectContainer,
IEssentiaTransport,
IThaumicInput {
    private int amount;
    private int maxAmount = 64;
    private Aspect aspect = null;
    public int count;

    @Override
    public int extractFuel(int ener) {
        if (this.amount <= 0 || this.aspect == null) {
            return 0;
        }
        float ratio = (float)ener / 80.0f;
        int val = this.getAspectFuel(this.aspect);
        if (ratio > (float)this.amount) {
            return 0;
        }
        this.amount = (int)((double)this.amount - Math.ceil(ratio));
        if (this.amount <= 0) {
            this.amount = 0;
            this.aspect = null;
        }
        return val;
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        comp.func_74777_a("Amount", (short)this.amount);
        if (this.aspect != null) {
            comp.func_74778_a("Aspect", this.aspect.getTag());
        }
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.amount = comp.func_74765_d("Amount");
        this.aspect = Aspect.getAspect((String)comp.func_74779_i("Aspect"));
    }

    public int getAspectFuel(Aspect aspect) {
        if (aspect == Aspect.FIRE || aspect == Aspect.ENERGY) {
            return 800;
        }
        if (aspect == Aspect.AIR || aspect == Aspect.ORDER) {
            return 75;
        }
        if (aspect == Aspect.WATER) {
            if (this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145848_d).func_76736_e()) {
                return 200;
            }
            return 50;
        }
        if (aspect == Aspect.MAGIC || aspect == Aspect.ELDRITCH) {
            if (this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145848_d) == BiomeGenBase.field_76779_k || this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145848_d) == ThaumcraftWorldGenerator.biomeMagicalForest) {
                return 300;
            }
            return 75;
        }
        if (aspect == Aspect.MECHANISM || aspect == Aspect.METAL || aspect == Aspect.MOTION || aspect == Aspect.TOOL || aspect == Aspect.TRAP || aspect == Aspect.MINE || aspect == Aspect.CRAFT || aspect == Aspect.TRAVEL) {
            return 75;
        }
        if (aspect == Aspect.CRYSTAL || aspect == Aspect.ENTROPY) {
            return 75;
        }
        if (aspect == Aspect.MAN || aspect == Aspect.SENSES | aspect == Aspect.HEAL || aspect == Aspect.HARVEST || aspect == Aspect.HUNGER || aspect == Aspect.DEATH || aspect == Aspect.BEAST || aspect == Aspect.POISON || aspect == Aspect.MIND || aspect == Aspect.SOUL || aspect == Aspect.WEAPON || aspect == Aspect.WEATHER) {
            return 30;
        }
        if (aspect == Aspect.VOID) {
            if (this.field_145848_d < 60) {
                return 200;
            }
            return 50;
        }
        if (aspect == Aspect.TREE || aspect == Aspect.PLANT || aspect == Aspect.CROP || aspect == Aspect.CLOTH || aspect == Aspect.FLESH) {
            return 40;
        }
        if (aspect == Aspect.UNDEAD && this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145848_d) == BiomeGenBase.field_76779_k) {
            return 100;
        }
        if (aspect == Aspect.EXCHANGE) {
            Random rand = new Random();
            return rand.nextInt(1200);
        }
        if (aspect == Aspect.FLIGHT) {
            if (this.field_145848_d > 150) {
                return 200;
            }
            return 50;
        }
        if (aspect == Aspect.SLIME) {
            if (this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76617_a(987234911L).nextInt(10) == 0) {
                return 200;
            }
            return 100;
        }
        if (aspect == Aspect.LIGHT) {
            if (this.field_145850_b.func_72935_r()) {
                return 300;
            }
            return 50;
        }
        if (aspect == Aspect.DARKNESS) {
            if (!this.field_145850_b.func_72935_r()) {
                return 300;
            }
            return 50;
        }
        if (aspect == Aspect.AURA) {
            if (this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145848_d) == ThaumcraftWorldGenerator.biomeMagicalForest) {
                return 600;
            }
            return 100;
        }
        if (aspect == Aspect.TAINT) {
            if (this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145848_d) == ThaumcraftWorldGenerator.biomeTaint) {
                return 600;
            }
            return 100;
        }
        return 25;
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.aspect != null && this.amount > 0) {
            al.add(this.aspect, this.amount);
        }
        return al;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.amount < this.maxAmount) {
            this.fill();
        }
    }

    public void fill() {
        TileEntity te = null;
        IEssentiaTransport ic = null;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == ForgeDirection.getOrientation((int)this.facing) || (te = Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir)) == null) continue;
            ic = (IEssentiaTransport)te;
            Aspect ta = ic.getEssentiaType(dir.getOpposite());
            if (ic.getEssentiaAmount(dir.getOpposite()) <= 0 || ic.getSuctionAmount(dir.getOpposite()) >= this.getSuctionAmount(null) || this.getSuctionAmount(null) < ic.getMinimumSuction()) continue;
            this.addToContainer(ta, ic.takeEssentia(ta, 1, dir.getOpposite()));
            return;
        }
    }

    public int addToContainer(Aspect tag, int am) {
        if (am == 0) {
            return am;
        }
        if (this.amount < this.maxAmount && tag == this.aspect || this.amount == 0) {
            this.aspect = tag;
            int added = Math.min(am, this.maxAmount - this.amount);
            this.amount += added;
            am -= added;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return am;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.amount >= amount && tag == this.aspect) {
            this.amount -= amount;
            if (this.amount <= 0) {
                this.aspect = null;
                this.amount = 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.amount >= amount && tag == this.aspect;
    }

    public boolean doesContainerContain(AspectList ot) {
        if (ot.size() > 1) {
            return false;
        }
        int i$ = 0;
        Aspect[] arr$ = ot.getAspects();
        int len$ = arr$.length;
        if (i$ < len$) {
            Aspect tt = arr$[i$];
            return this.doesContainerContainAmount(tt, ot.getAmount(tt));
        }
        return false;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int getMinimumSuction() {
        return 128;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public boolean isConnectable(ForgeDirection face) {
        return face != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return (this.aspect == null || tag == this.aspect) && this.amount < this.maxAmount;
    }

    public int containerContains(Aspect tag) {
        return this.aspect != null && tag == this.aspect ? this.amount : 0;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setAspects(AspectList aspects) {
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        if (this.amount > 0) {
            return this.aspect;
        }
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        if (this.amount < this.maxAmount) {
            return 128;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return amount - this.addToContainer(aspect, amount);
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.aspect;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.amount;
    }
}

