/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.botania.machines;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.tiles.base.IWrenchable;
import theflogat.technomancy.common.tiles.base.TileMachineBase;
import theflogat.technomancy.lib.handlers.Rate;
import theflogat.technomancy.util.helpers.WorldHelper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaPool;

public class TileManaFabricator
extends TileMachineBase
implements IManaPool,
IWrenchable {
    public int maxMana = 100000;
    public int mana;
    public int facing;
    public static int cost = Rate.manaFabCost;

    public TileManaFabricator() {
        super(Rate.manaFabCost * 2);
    }

    public void func_145845_h() {
        if (this.getEnergyStored() >= cost && this.mana + 100 <= this.maxMana) {
            this.mana += 100;
            this.extractEnergy(cost, false);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        compound.func_74768_a("Mana", this.mana);
        compound.func_74768_a("Facing", this.facing);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.mana = compound.func_74762_e("Mana");
        this.facing = compound.func_74762_e("Facing");
    }

    public boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public void recieveMana(int mana) {
        this.mana += mana;
    }

    public boolean canRecieveManaFromBursts() {
        return false;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int color = 0x660000FF;
        BotaniaAPI.internalHandler.drawSimpleManaHUD(color, this.mana, this.maxMana, TMBlocks.manaFabricator.func_149732_F(), res);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from.ordinal() == this.facing;
    }

    @Override
    public boolean onWrenched(boolean sneaking) {
        for (int i = this.facing + 1; i < this.facing + 6; ++i) {
            TileEntity tile = WorldHelper.getAdjacentTileEntity((TileEntity)this, (byte)(i % 6));
            if (!WorldHelper.isEnergyHandlerFromOppFacing(tile, (byte)(i % 6))) continue;
            if (!this.field_145850_b.field_72995_K) {
                this.facing = (byte)(i % 6);
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }
}

