/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.botania.machines;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.IWrenchable;
import theflogat.technomancy.common.tiles.base.TileTechnomancyRedstone;
import theflogat.technomancy.lib.handlers.Rate;
import vazkii.botania.common.block.tile.mana.TilePool;

public class TileManaExchanger
extends TileTechnomancyRedstone
implements IFluidHandler,
IEnergyReceiver,
IWrenchable {
    public FluidTank tank = new FluidTank(1000);
    public boolean mode;
    public boolean active;
    public EnergyStorage storage = new EnergyStorage(Rate.exchangerCost * 10);

    public TileManaExchanger() {
        super(IRedstoneSensitive.RedstoneSet.LOW);
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        this.tank.writeToNBT(comp);
        comp.func_74757_a("Mode", this.mode);
        this.storage.writeToNBT(comp);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.tank = new FluidTank(1000);
        this.tank.readFromNBT(comp);
        this.mode = comp.func_74767_n("Mode");
        this.storage.readFromNBT(comp);
    }

    public void func_145845_h() {
        if (!this.set.canRun(this)) {
            this.active = false;
            return;
        }
        this.active = true;
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (tile instanceof TilePool) {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            TilePool pool = (TilePool)tile;
            if (this.storage.getEnergyStored() >= Rate.exchangerCost) {
                if (this.mode) {
                    if (this.tank.getFluidAmount() > 0 && pool.getCurrentMana() <= pool.manaCap - 1000) {
                        pool.recieveMana(1000);
                        this.tank.drain(1, true);
                        this.storage.extractEnergy(Rate.exchangerCost, false);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    }
                } else if (this.tank.getFluidAmount() < this.tank.getCapacity() && pool.getCurrentMana() >= 1000) {
                    pool.recieveMana(-1000);
                    this.tank.fill(new FluidStack(TMBlocks.manaFluid, 1), true);
                    this.storage.extractEnergy(Rate.exchangerCost, false);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                }
            }
        } else {
            this.active = false;
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() != TMBlocks.manaFluid || from == ForgeDirection.UP || !this.mode) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() != TMBlocks.manaFluid) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UP || this.mode) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && this.mode;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && !this.mode;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean onWrenched(boolean sneaking) {
        this.mode = !this.mode;
        return true;
    }
}

