/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import theflogat.technomancy.lib.Ids;
import theflogat.technomancy.lib.Ref;
import theflogat.technomancy.network.PacketHandler;
import theflogat.technomancy.util.Loc;

public class PlayerData {
    public static NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound forgeData = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound data = forgeData.func_74775_l("technom");
        if (data == null) {
            data = new NBTTagCompound();
        }
        if (!forgeData.func_74764_b("technom")) {
            forgeData.func_74782_a("technom", (NBTBase)data);
        }
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)forgeData);
        }
        return data;
    }

    public static void prepareData(EntityPlayer player) {
        NBTTagCompound data;
        if (Loc.isServer()) {
            PlayerData.syncData(player);
        }
        if (!(data = PlayerData.getData(player)).func_74764_b("existencelevel")) {
            data.func_74768_a("existencelevel", 1);
            data.func_74768_a("rexistencelevel", 0);
        }
        if (!data.func_74764_b("existencepower")) {
            data.func_74768_a("existencepower", 1);
        }
        for (Affinity aff : Affinity.allAff) {
            if (data.func_74764_b(aff.getName())) continue;
            data.func_74768_a(aff.getName(), 1);
            data.func_74768_a(aff.getRName(), 0);
        }
    }

    public static void syncData(EntityPlayer player) {
        PacketHandler.instance.sendTo(PacketHandler.getPacket((EntityPlayerMP)player), (EntityPlayerMP)player);
    }

    public static Affinity getAffinity(EntityPlayer player) {
        NBTTagCompound data = PlayerData.getData(player);
        if (data.func_74762_e("existencelevel") >= 20) {
            HashMap<Affinity, Integer> map = PlayerData.getAffinityValues(data);
            int total = map.get((Object)Affinity.NORMAL);
            for (Affinity aff : Affinity.allAff) {
                if (map.get((Object)aff) <= total / 2) continue;
                return aff;
            }
        }
        return Affinity.NORMAL;
    }

    public static HashMap<Affinity, Integer> getAffinityValues(NBTTagCompound data) {
        HashMap<Affinity, Integer> map = new HashMap<Affinity, Integer>();
        int total = 0;
        for (Affinity aff : Affinity.allAff) {
            map.put(aff, data.func_74762_e(aff.getName()));
            total += data.func_74762_e(aff.getName());
        }
        map.put(Affinity.NORMAL, total);
        return map;
    }

    public static void addAffinity(World w, EntityPlayer player, Affinity aff, int i) {
        if (aff == null) {
            return;
        }
        NBTTagCompound data = PlayerData.getData(player);
        for (int j = 0; j < i; ++j) {
            try {
                int randVal = data.func_74762_e(aff.getName()) * 10 - data.func_74762_e(aff.getRName());
                if (w.field_73012_v.nextInt(randVal) == 0) {
                    data.func_74768_a(aff.getName(), data.func_74762_e(aff.getName()) + 1);
                    data.func_74768_a(aff.getRName(), 0);
                    continue;
                }
                data.func_74768_a(aff.getRName(), data.func_74762_e(aff.getRName()) + 1);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addExistencePower(World w, String userName) {
        NBTTagCompound data = PlayerData.getData(w.func_72924_a(userName));
        int randVal = data.func_74762_e("existencelevel") * 100 - data.func_74762_e("rexistencelevel");
        if (w.field_73012_v.nextInt(randVal) == 0) {
            data.func_74768_a("existencelevel", data.func_74762_e("existencelevel") + 1);
            data.func_74768_a("rexistencelevel", 0);
        } else {
            data.func_74768_a("rexistencelevel", data.func_74762_e("rexistencelevel") + 1);
        }
    }

    public static void addExistencePower(Random rand, EntityPlayer player) {
        NBTTagCompound data = PlayerData.getData(player);
        if (data.func_74764_b("existencelevel")) {
            int randVal = data.func_74762_e("existencelevel") * 100 - data.func_74762_e("rexistencelevel");
            if (rand.nextInt(randVal) == 0) {
                data.func_74768_a("existencelevel", data.func_74762_e("existencelevel") + 1);
                data.func_74768_a("rexistencelevel", 0);
            } else {
                data.func_74768_a("rexistencelevel", data.func_74762_e("rexistencelevel") + 1);
            }
        }
    }

    public static int getExistenceLevel(EntityPlayer player) {
        NBTTagCompound data = PlayerData.getData(player);
        if (player == null || !data.func_74764_b("existencelevel")) {
            return 1;
        }
        return data.func_74762_e("existencelevel");
    }

    public static int getCurrentPower(EntityPlayer player) {
        NBTTagCompound data = PlayerData.getData(player);
        if (player == null || !data.func_74764_b("existencepower")) {
            return 1;
        }
        return data.func_74762_e("existencepower");
    }

    public static void renderHUD(EntityPlayer player) {
        HUDHandler.renderHUD(PlayerData.getCurrentPower(player), PlayerData.getExistenceLevel(player));
    }

    @SideOnly(value=Side.CLIENT)
    public static class HUDHandler {
        public static final ResourceLocation modelTexture = new ResourceLocation("technom:textures/models/hud.png");
        public static final ResourceLocation exTexture = new ResourceLocation("technom:textures/models/exHud.png");

        public static void renderHUD(int amt, int maxAmount) {
            GL11.glPushMatrix();
            int xSize = 32;
            int ySize = 32;
            float ratio = (float)amt / (float)maxAmount;
            int scale = 20;
            int amount = (int)((float)scale * ratio);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(modelTexture);
            HUDHandler.drawRectangle(Ids.hudStartX, Ids.hudStartY, 0, 0, xSize, ySize);
            Color c = PlayerData.getAffinity((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getColor();
            GL11.glColor3f((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(exTexture);
            HUDHandler.drawRectangle(Ids.hudStartX, Ids.hudStartY + 5 + scale - amount, 0, 0, xSize, amount);
            GL11.glPopMatrix();
        }

        public static void drawRectangle(int x, int y, int u, int v, double width, double length) {
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)y + length, 0.0, (double)((float)u * f), ((double)v + length) * (double)f1);
            tessellator.func_78374_a((double)x + width, (double)y + length, 0.0, ((double)u + width) * (double)f, ((double)v + length) * (double)f1);
            tessellator.func_78374_a((double)x + width, (double)y, 0.0, ((double)u + width) * (double)f, (double)((float)v * f1));
            tessellator.func_78374_a((double)x, (double)y, 0.0, (double)((float)u * f), (double)((float)v * f1));
            tessellator.func_78381_a();
        }
    }

    public static enum Affinity {
        EARTH(0),
        FIRE(1),
        WATER(2),
        LIGHT(3),
        DARK(4),
        NORMAL(5);

        int id;
        public static Affinity[] allAff;

        private Affinity(int id) {
            id = this.ordinal();
        }

        public String getName() {
            switch (this.id) {
                case 0: {
                    return Ref.getId("earth");
                }
                case 1: {
                    return Ref.getId("fire");
                }
                case 2: {
                    return Ref.getId("water");
                }
                case 3: {
                    return Ref.getId("light");
                }
                case 4: {
                    return Ref.getId("dark");
                }
            }
            return Ref.getId("normal");
        }

        public Color getColor() {
            switch (this.id) {
                case 0: {
                    return Color.GREEN;
                }
                case 1: {
                    return Color.RED;
                }
                case 2: {
                    return Color.BLUE;
                }
                case 3: {
                    return Color.WHITE;
                }
                case 4: {
                    return Color.BLACK;
                }
            }
            return new Color(0x2266AA);
        }

        public String getRName() {
            return "r" + this.getName();
        }

        public static Affinity getAffinity(int id) {
            for (Affinity aff : allAff) {
                if (aff.id != id) continue;
                return aff;
            }
            return NORMAL;
        }

        static {
            allAff = new Affinity[]{EARTH, FIRE, WATER, LIGHT, DARK};
        }
    }
}

