/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.blocks.thaumcraft.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import theflogat.technomancy.common.blocks.base.BlockContainerAdvanced;
import theflogat.technomancy.common.tiles.thaumcraft.machine.TileCondenser;
import theflogat.technomancy.lib.Ref;
import theflogat.technomancy.lib.compat.Thaumcraft;

public class BlockCondenser
extends BlockContainerAdvanced {
    static AspectList phialAspect = new AspectList().add(Aspect.ENERGY, 8);
    @SideOnly(value=Side.CLIENT)
    IIcon[] icons;

    public BlockCondenser() {
        this.func_149663_c(Ref.getId("condenserBlock"));
    }

    @Override
    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        boolean flag = super.func_149727_a(w, x, y, z, player, side, hitX, hitY, hitZ);
        ItemStack item = player.func_70694_bm();
        TileCondenser condenser = BlockCondenser.getTE((IBlockAccess)w, x, y, z);
        if (condenser != null && player.func_70093_af()) {
            return condenser.toggleDir(side);
        }
        if (item != null && item.func_77973_b() == Thaumcraft.itemEssence && item.func_77960_j() == 0 && condenser.amount >= 8 && condenser.takeFromContainer(Aspect.ENERGY, 8)) {
            --item.field_77994_a;
            w.func_72956_a((Entity)player, "game.neutral.swim", 0.25f, 1.0f);
            ItemStack phial = new ItemStack(Thaumcraft.itemEssence, 1, 1);
            if (!phial.func_77942_o()) {
                phial.func_77982_d(new NBTTagCompound());
            }
            phialAspect.writeToNBT(phial.func_77978_p());
            if (!player.field_71071_by.func_70441_a(phial)) {
                w.func_72838_d((Entity)new EntityItem(w, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), phial));
            }
            player.field_71069_bz.func_75142_b();
            return true;
        }
        return flag;
    }

    @Override
    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase entity, ItemStack items) {
        super.func_149689_a(w, x, y, z, entity, items);
        int rotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        w.func_72921_c(x, y, z, rotation, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        this.icons = new IIcon[6];
        this.icons[0] = icon.func_94245_a(Ref.getAsset("condenserBlockFront"));
        this.icons[1] = icon.func_94245_a(Ref.getAsset("condenserBlockSide"));
        this.icons[2] = icon.func_94245_a(Ref.getAsset("condenserBlockTop"));
        this.icons[3] = icon.func_94245_a(Ref.getAsset("condenserBlockBottom"));
        this.icons[4] = icon.func_94245_a(Ref.getAsset("condenserBlockOut"));
        this.icons[5] = icon.func_94245_a(Ref.getAsset("condenserBlockOut2"));
    }

    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int side) {
        if (w.func_147438_o(x, y, z) instanceof TileCondenser && ((TileCondenser)w.func_147438_o((int)x, (int)y, (int)z)).sides.get(ForgeDirection.VALID_DIRECTIONS[side]).booleanValue()) {
            if (side == 0 || side == 1) {
                return this.icons[5];
            }
            return this.icons[4];
        }
        return this.func_149691_a(side, w.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.icons[2];
        }
        if (side == 1) {
            return this.icons[3];
        }
        if (side == BlockCondenser.getFacingFromMeta(meta)) {
            return this.icons[0];
        }
        return this.icons[1];
    }

    public TileEntity func_149915_a(World w, int meta) {
        return new TileCondenser();
    }

    public static int getFacingFromMeta(int meta) {
        switch (meta) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    private static TileCondenser getTE(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof TileCondenser ? (TileCondenser)tile : null;
    }
}

