/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.client.gui.tome.buttons;

import java.awt.Color;
import java.util.ArrayList;
import theflogat.technomancy.client.gui.tome.GuiTomeTemplate;
import theflogat.technomancy.client.gui.tome.render.pages.Page;

public class ButtonEntry {
    private int x = 0;
    private int y = 0;
    int id;
    ArrayList<String> text;
    int xsize = 0;
    int ysize = 6;
    Page[] allPages;
    int currentPage;

    public ButtonEntry(ArrayList<String> txt, Page[] pages) {
        this.text = txt;
        this.ysize += 8 * (txt.size() - 1);
        this.allPages = pages;
    }

    public ButtonEntry(String txt, Page[] pages) {
        this.text = new ArrayList();
        this.text.add(txt);
        this.allPages = pages;
    }

    public void setYX(int x2, int y2) {
        this.x = x2;
        this.y = y2;
    }

    public void setId(int newId) {
        this.id = newId;
    }

    public void draw(int left, int top, GuiTomeTemplate gui, boolean isHovering) {
        for (int i = 0; i < this.text.size(); ++i) {
            gui.getFont().func_78276_b(this.text.get(i), left + this.x, top + this.y + i * 8, isHovering ? Color.blue.getRGB() : 0);
        }
    }

    public boolean isPointInRegion(int mouseX, int mouseY, int left, int top, GuiTomeTemplate gui) {
        if (this.xsize == 0) {
            for (String s : this.text) {
                this.xsize = Math.max(gui.getFont().func_78256_a(s), this.xsize);
            }
        }
        int posX = mouseX - left;
        int posY = mouseY - top;
        return this.getX() <= posX && posX <= this.getX() + this.xsize && this.getY() <= posY && posY <= this.getY() + this.ysize;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void drawPage(GuiTomeTemplate gui, int left, int top, int activePage) {
        try {
            this.allPages[activePage * 2].draw(gui, left, top, false);
            this.allPages[activePage * 2 + 1].draw(gui, left, top, true);
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public int getId() {
        return this.id;
    }
}

