/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.api.rituals;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import theflogat.technomancy.common.player.PlayerData;
import theflogat.technomancy.util.helpers.RitualHelper;

public abstract class Ritual {
    protected Type[] frame = new Type[]{null, null, null};
    protected Type core;
    protected int id = 0;

    public Ritual(Type[] frame, Type core) {
        for (int i = 0; i < Math.min(frame.length, this.frame.length); ++i) {
            this.frame[i] = frame[i];
        }
        this.core = core;
    }

    protected void setId(int id) {
        this.id = id;
    }

    public boolean isCoreComplete(World w, int x, int y, int z) {
        return w.func_72805_g(x, y, z) == this.core.id;
    }

    public boolean isFrameComplete(World w, int x, int y, int z) {
        for (int i = 0; i < this.frame.length; ++i) {
            if (!(this.frame[i] == null ? !this.checkEmpty(w, x, y, z, i) : !RitualHelper.checkForT(w, x, y, z, this.frame[i].id, i))) continue;
            return false;
        }
        return true;
    }

    protected void removeFrame(World w, int x, int y, int z) {
        for (int i = 0; i < this.frame.length; ++i) {
            if (this.frame[i] == null) continue;
            RitualHelper.removeT(w, x, y, z, i);
        }
    }

    protected boolean checkEmpty(World w, int x, int y, int z, int tier) {
        for (Type t : Type.allTypes) {
            if (!RitualHelper.checkForT(w, x, y, z, t.id, tier)) continue;
            return false;
        }
        return true;
    }

    public void addAffinity(World w, String playerName) {
        int i;
        EntityPlayer player = w.func_72924_a(playerName);
        if (player == null) {
            return;
        }
        PlayerData.addAffinity(w, player, this.core.getAffinity(), 5);
        for (Type t : this.frame) {
            if (t == null) continue;
            PlayerData.addAffinity(w, player, t.getAffinity(), 1);
        }
        int j = 0;
        for (i = 0; i < this.frame.length; ++i) {
            if (this.frame[i] == null) continue;
            ++j;
        }
        for (i = 0; i <= 25 * j; ++i) {
            PlayerData.addExistencePower(w.field_73012_v, player);
        }
    }

    public abstract boolean canApplyEffect(World var1, int var2, int var3, int var4);

    public abstract void applyEffect(World var1, int var2, int var3, int var4);

    public static enum Type {
        EARTH(0),
        FIRE(1),
        WATER(2),
        LIGHT(3),
        DARK(4);

        int id;
        static Type[] allTypes;

        private Type(int id) {
            this.id = id;
        }

        public static Type getType(int id) {
            for (Type t : allTypes) {
                if (t.id != id) continue;
                return t;
            }
            return null;
        }

        public PlayerData.Affinity getAffinity() {
            return PlayerData.Affinity.getAffinity(this.id);
        }

        static {
            allTypes = new Type[]{EARTH, FIRE, WATER, LIGHT, DARK};
        }
    }
}

