/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemArmor;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.Logger;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.items.base.TMItems;
import theflogat.technomancy.common.potions.TMPotions;
import theflogat.technomancy.lib.compat.IModModule;
import theflogat.technomancy.lib.handlers.CompatibilityHandler;
import theflogat.technomancy.lib.handlers.ConfigHandler;
import theflogat.technomancy.lib.handlers.CraftingHandler;
import theflogat.technomancy.lib.handlers.CreativeTabTM;
import theflogat.technomancy.lib.handlers.EventRegister;
import theflogat.technomancy.network.PacketHandler;
import theflogat.technomancy.proxies.CommonProxy;
import theflogat.technomancy.util.Ore;

@Mod(modid="technom", name="Technomancy", version="0.12.5", dependencies="after:*")
public class Technomancy {
    @Mod.Instance(value="technom")
    public static Technomancy instance;
    @SidedProxy(clientSide="theflogat.technomancy.proxies.ClientProxy", serverSide="theflogat.technomancy.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tabsTM;
    public static Logger logger;
    public static ItemArmor.ArmorMaterial existencePower;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        if (Potion.field_76425_a.length < 256) {
            this.expandPotions();
        }
        ConfigHandler.init(new File(event.getModConfigurationDirectory(), "Technomancy.cfg"));
        PacketHandler.instance = new PacketHandler();
        new EventRegister();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CompatibilityHandler.init();
        for (IModModule mod : CompatibilityHandler.mods) {
            mod.Init();
        }
        TMItems.initTechnomancy();
        TMBlocks.initTechnomancy();
        TMPotions.initTechnomancy();
        for (IModModule mod : CompatibilityHandler.mods) {
            mod.RegisterBlocks();
            mod.RegisterItems();
        }
        proxy.initRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"theflogat.technomancy.lib.compat.waila.WailaProvider.callbackRegister");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Ore.init();
        ConfigHandler.initOreConfigs();
        TMItems.initPureOres();
        CraftingHandler.initTechnomancyRecipes();
        CraftingHandler.initFurnaceRecipes();
        for (IModModule mod : CompatibilityHandler.mods) {
            mod.RegisterRecipes();
        }
        for (IModModule mod : CompatibilityHandler.mods) {
            mod.PostInit();
        }
    }

    private void expandPotions() {
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[256];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                logger.warn("Unable to expand potion array. Error:", (Throwable)e);
                break;
            }
        }
    }

    static {
        tabsTM = new CreativeTabTM(CreativeTabs.getNextID(), "technom");
        existencePower = EnumHelper.addArmorMaterial((String)"existencePower", (int)20, (int[])new int[]{4, 4, 4, 4}, (int)35);
    }
}

