/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import ru.fewizz.idextender.asm.AsmTransformException;
import ru.fewizz.idextender.asm.ClassEdit;

public class IETransformer
implements IClassTransformer {
    private static final boolean enablePreVerification = false;
    private static final boolean enablePostVerification = true;
    public static final Logger logger = LogManager.getLogger((String)"NEID");
    public static boolean isObfuscated;
    private static Boolean isClient;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        ClassEdit edit = ClassEdit.get(transformedName);
        if (edit == null) {
            return bytes;
        }
        logger.debug("Patching {} with {}...", new Object[]{transformedName, edit.getName()});
        ClassNode cn = new ClassNode(327680);
        ClassReader reader = new ClassReader(bytes);
        boolean readFlags = false;
        reader.accept((ClassVisitor)cn, 0);
        try {
            edit.getTransformer().transform(cn, isObfuscated);
        }
        catch (AsmTransformException t) {
            logger.error("Error transforming {} with {}: {}", new Object[]{transformedName, edit.getName(), t.getMessage()});
            throw t;
        }
        catch (Throwable t) {
            logger.error("Error transforming {} with {}: {}", new Object[]{transformedName, edit.getName(), t.getMessage()});
            throw new RuntimeException(t);
        }
        ClassWriter writer = new ClassWriter(0);
        try {
            CheckClassAdapter check = new CheckClassAdapter((ClassVisitor)writer);
            cn.accept((ClassVisitor)check);
        }
        catch (Throwable t) {
            logger.error("Error verifying {} transformed with {}: {}", new Object[]{transformedName, edit.getName(), t.getMessage()});
            throw new RuntimeException(t);
        }
        logger.debug("Patched {} successfully.", new Object[]{edit.getName()});
        return writer.toByteArray();
    }

    public static boolean isClient() {
        if (isClient == null) {
            isClient = IETransformer.class.getResource("/net/minecraft/client/main/Main.class") != null;
        }
        return isClient;
    }

    static {
        isClient = null;
    }
}

