/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender.asm;

import java.io.PrintWriter;
import java.util.ListIterator;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import ru.fewizz.idextender.asm.AsmTransformException;
import ru.fewizz.idextender.asm.FieldNotFoundException;
import ru.fewizz.idextender.asm.MethodNotFoundException;
import ru.fewizz.idextender.asm.Name;

public class AsmUtil {
    public static MethodNode findMethod(ClassNode cn, String name) {
        return AsmUtil.findMethod(cn, name, false);
    }

    public static MethodNode findMethod(ClassNode cn, String name, boolean optional) {
        for (MethodNode ret : cn.methods) {
            if (!ret.name.equals(name)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new MethodNotFoundException(name);
    }

    public static MethodNode findMethod(ClassNode cn, Name name) {
        return AsmUtil.findMethod(cn, name, false);
    }

    public static MethodNode findMethod(ClassNode cn, Name name, boolean optional) {
        for (MethodNode ret : cn.methods) {
            if (!name.matches(ret)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new MethodNotFoundException(name.deobf);
    }

    public static FieldNode findField(ClassNode cn, String name) {
        return AsmUtil.findField(cn, name, false);
    }

    public static FieldNode findField(ClassNode cn, String name, boolean optional) {
        for (FieldNode ret : cn.fields) {
            if (!name.equals(ret.name)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new FieldNotFoundException(name);
    }

    public static FieldNode findField(ClassNode cn, Name name) {
        return AsmUtil.findField(cn, name, false);
    }

    public static FieldNode findField(ClassNode cn, Name name, boolean optional) {
        for (FieldNode ret : cn.fields) {
            if (!name.matches(ret)) continue;
            return ret;
        }
        if (optional) {
            return null;
        }
        throw new FieldNotFoundException(name.deobf);
    }

    public static void makePublic(MethodNode x) {
        x.access = x.access & 0xFFFFFFF9 | 1;
    }

    public static void makePublic(FieldNode x) {
        x.access = x.access & 0xFFFFFFF9 | 1;
    }

    public static boolean transformInlinedSizeMethod(ClassNode cn, MethodNode method, int oldValue, int newValue) {
        return AsmUtil.transformInlinedSizeMethod(cn, method, oldValue, newValue, false);
    }

    public static boolean transformInlinedSizeMethod(ClassNode cn, MethodNode method, int oldValue, int newValue, boolean optional) {
        boolean found = false;
        boolean foundOnce = false;
        boolean i = false;
        ListIterator it = method.instructions.iterator();
        while (it.hasNext()) {
            LdcInsnNode node;
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn.getOpcode() == 3 && oldValue == 0) {
                found = true;
            } else if (insn.getOpcode() == 4 && oldValue == 1) {
                found = true;
            } else if (insn.getOpcode() == 5 && oldValue == 2) {
                found = true;
            } else if (insn.getOpcode() == 6 && oldValue == 3) {
                found = true;
            } else if (insn.getOpcode() == 7 && oldValue == 4) {
                found = true;
            } else if (insn.getOpcode() == 8 && oldValue == 5) {
                found = true;
            } else if (insn.getOpcode() == 18) {
                node = (LdcInsnNode)insn;
                if (node.cst instanceof Integer && (Integer)node.cst == oldValue) {
                    found = true;
                }
            } else if (insn.getOpcode() == 17 || insn.getOpcode() == 16) {
                node = (IntInsnNode)insn;
                if (node.operand == oldValue) {
                    found = true;
                }
            }
            if (!found) continue;
            foundOnce = true;
            if (newValue == 0) {
                it.set(new InsnNode(3));
            } else if (newValue == 1) {
                it.set(new InsnNode(4));
            } else if (newValue == 2) {
                it.set(new InsnNode(5));
            } else if (newValue == 3) {
                it.set(new InsnNode(6));
            } else if (newValue == 4) {
                it.set(new InsnNode(7));
            } else if (newValue == 5) {
                it.set(new InsnNode(8));
            } else if (newValue >= -128 && newValue <= 127) {
                it.set(new IntInsnNode(16, newValue));
            } else if (newValue >= Short.MIN_VALUE && newValue <= Short.MAX_VALUE) {
                it.set(new IntInsnNode(17, newValue));
            } else {
                it.set(new LdcInsnNode((Object)newValue));
            }
            found = false;
        }
        if (!foundOnce && !optional) {
            throw new AsmTransformException("can't find constant value " + oldValue + " in method " + method.name);
        }
        return foundOnce;
    }

    public static void dump(InsnList list) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)textifier);
        list.accept((MethodVisitor)visitor);
        PrintWriter writer = new PrintWriter(System.out);
        textifier.print(writer);
        writer.flush();
    }
}

