/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.util.position;

import me.planetguy.remaininmotion.api.event.IBlockPos;
import me.planetguy.remaininmotion.base.TileEntityRiM;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRecord
implements Comparable<BlockRecord>,
IBlockPos {
    public int X;
    public int Y;
    public int Z;
    public Block block;
    public int Meta;
    public TileEntity entity;
    public NBTTagCompound entityRecord;
    public World World;

    public String toString() {
        return "(" + this.X + "," + this.Y + "," + this.Z + ")";
    }

    public BlockRecord(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        this.Identify(te.func_145831_w());
    }

    public BlockRecord(int X, int Y, int Z) {
        this.X = X;
        this.Y = Y;
        this.Z = Z;
    }

    public BlockRecord(BlockRecord Record) {
        this.X = Record.X;
        this.Y = Record.Y;
        this.Z = Record.Z;
    }

    public BlockRecord(ForgeDirection offset, BlockRecord base) {
        this(base);
        this.shift(offset);
    }

    public void Shift(Directions Direction) {
        this.X += Direction.deltaX;
        this.Y += Direction.deltaY;
        this.Z += Direction.deltaZ;
    }

    public BlockRecord shift(ForgeDirection dir) {
        this.X += dir.offsetX;
        this.Y += dir.offsetY;
        this.Z += dir.offsetZ;
        return this;
    }

    public BlockRecord NextInDirection(Directions Direction) {
        return new BlockRecord(this.X + Direction.deltaX, this.Y + Direction.deltaY, this.Z + Direction.deltaZ);
    }

    @Override
    public int compareTo(BlockRecord Target2) {
        int Result = this.X - Target2.X;
        if (Result == 0 && (Result = this.Y - Target2.Y) == 0) {
            Result = this.Z - Target2.Z;
        }
        return Result;
    }

    public void Identify(World World2) {
        this.World = World2;
        this.block = World2.func_147439_a(this.X, this.Y, this.Z);
        this.Meta = World2.func_72805_g(this.X, this.Y, this.Z);
        this.entity = World2.func_147438_o(this.X, this.Y, this.Z);
    }

    public static BlockRecord Identified(TileEntityRiM Anchor, int X, int Y, int Z) {
        BlockRecord Record = new BlockRecord(X, Y, Z);
        Record.Identify(Anchor.func_145831_w());
        return Record;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("X", this.X);
        tag.func_74768_a("Y", this.Y);
        tag.func_74768_a("Z", this.Z);
        tag.func_74768_a("Id", Block.func_149682_b((Block)this.block));
        tag.func_74768_a("Meta", this.Meta);
        if (this.entityRecord != null) {
            tag.func_74782_a("EntityRecord", (NBTBase)this.entityRecord);
        }
    }

    public static BlockRecord createFromNBT(NBTTagCompound tag) {
        BlockRecord record = new BlockRecord(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
        record.block = Block.func_149729_e((int)tag.func_74762_e("Id"));
        record.Meta = tag.func_74762_e("Meta");
        if (tag.func_74764_b("EntityRecord")) {
            record.entityRecord = tag.func_74775_l("EntityRecord");
        }
        return record;
    }

    @Override
    public World world() {
        return this.World;
    }

    @Override
    public int x() {
        return this.X;
    }

    @Override
    public int y() {
        return this.Y;
    }

    @Override
    public int z() {
        return this.Z;
    }

    @Override
    public TileEntity entity() {
        return this.entity;
    }

    @Override
    public NBTTagCompound entityTag() {
        return this.entityRecord;
    }
}

