/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import me.planetguy.remaininmotion.render.Render;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public abstract class BlockRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public int RenderId;
    public int X;
    public int Y;
    public int Z;
    public int Brightness;
    public double SideMinH;
    public double SideMinV;
    public double SideMaxH;
    public double SideMaxV;
    public double TextureMinU;
    public double TextureMinV;
    public double TextureMaxU;
    public double TextureMaxV;

    public int getRenderId() {
        return this.RenderId;
    }

    public int Initialize(Block block) {
        this.RenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)this);
        return this.RenderId;
    }

    public void Render(TileEntity TileEntity2) {
    }

    public boolean renderWorldBlock(IBlockAccess World2, int X, int Y, int Z, Block Block2, int RenderId, RenderBlocks RenderBlocks2) {
        this.X = X;
        this.Y = Y;
        this.Z = Z;
        this.Brightness = Block2.func_149677_c(World2, X, Y, Z);
        RenderBlocks2.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        RenderBlocks2.func_147784_q(Block2, X, Y, Z);
        this.Render(World2.func_147438_o(X, Y, Z));
        return true;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public void renderInventoryBlock(Block Block2, int Meta, int RenderId, RenderBlocks RenderBlocks2) {
    }

    public boolean handleRenderType(ItemStack Item2, IItemRenderer.ItemRenderType Type2) {
        switch (Type2) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType Type2, ItemStack Item2, IItemRenderer.ItemRendererHelper Helper) {
        return true;
    }

    public abstract IIcon GetIcon(ItemStack var1, Directions var2);

    public void renderItem(IItemRenderer.ItemRenderType Type2, ItemStack Item2, Object ... Arguments) {
        RenderBlocks renderBlocks = (RenderBlocks)Arguments[0];
        renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (Type2 == IItemRenderer.ItemRenderType.ENTITY) {
            Render.Translate(-0.5, -0.5, -0.5);
        }
        Render.Begin();
        Render.SetNormal(Directions.NegY);
        renderBlocks.func_147768_a(null, 0.0, 0.0, 0.0, this.GetIcon(Item2, Directions.NegY));
        Render.SetNormal(Directions.PosY);
        renderBlocks.func_147806_b(null, 0.0, 0.0, 0.0, this.GetIcon(Item2, Directions.PosY));
        Render.SetNormal(Directions.NegZ);
        renderBlocks.func_147761_c(null, 0.0, 0.0, 0.0, this.GetIcon(Item2, Directions.NegZ));
        Render.SetNormal(Directions.PosZ);
        renderBlocks.func_147734_d(null, 0.0, 0.0, 0.0, this.GetIcon(Item2, Directions.PosZ));
        Render.SetNormal(Directions.NegX);
        renderBlocks.func_147798_e(null, 0.0, 0.0, 0.0, this.GetIcon(Item2, Directions.NegX));
        Render.SetNormal(Directions.PosX);
        renderBlocks.func_147764_f(null, 0.0, 0.0, 0.0, this.GetIcon(Item2, Directions.PosX));
        Render.End();
    }

    public void SetSideSpan(double SideMinH, double SideMinV, double SideMaxH, double SideMaxV) {
        this.SideMinH = SideMinH;
        this.SideMinV = SideMinV;
        this.SideMaxH = SideMaxH;
        this.SideMaxV = SideMaxV;
    }

    public void SubsectSideSpan(double SubsectMinH, double SubsectMinV, double SubsectMaxH, double SubsectMaxV) {
        double SideSpanH = this.SideMaxH - this.SideMinH;
        double SideSpanV = this.SideMaxV - this.SideMinV;
        this.SideMinH += SideSpanH * SubsectMinH;
        this.SideMinV += SideSpanV * SubsectMinV;
        this.SideMaxH -= SideSpanH * (1.0 - SubsectMaxH);
        this.SideMaxV -= SideSpanV * (1.0 - SubsectMaxV);
    }

    public void SetTextureSpan(IIcon Texture) {
        this.TextureMinU = Texture.func_94214_a(0.0);
        this.TextureMinV = Texture.func_94207_b(0.0);
        this.TextureMaxU = Texture.func_94214_a(16.0);
        this.TextureMaxV = Texture.func_94207_b(16.0);
    }

    public void SubsectTextureSpan(double SubsectMinU, double SubsectMinV, double SubsectMaxU, double SubsectMaxV) {
        double TextureSpanU = this.TextureMaxU - this.TextureMinU;
        double TextureSpanV = this.TextureMaxV - this.TextureMinV;
        this.TextureMinU += TextureSpanU * SubsectMinU;
        this.TextureMinV += TextureSpanV * SubsectMinV;
        this.TextureMaxU -= TextureSpanU * (1.0 - SubsectMaxU);
        this.TextureMaxV -= TextureSpanV * (1.0 - SubsectMaxV);
    }

    public void SetTint(double Tint) {
        Render.SetBrightness(this.Brightness);
        Render.SetColorFactor(Tint);
    }

    public void RenderGhost(int OffsetX, int OffsetY, int OffsetZ) {
        this.RenderBlock(this.X + OffsetX, this.Y + OffsetY, this.Z + OffsetZ, -0.001, null, true);
    }

    public void RenderOverlay(double Outset, boolean[] SidesToRender, boolean RenderSideFlag) {
        this.RenderBlock(this.X, this.Y, this.Z, Outset, SidesToRender, RenderSideFlag);
    }

    public void RenderBlock(int X, int Y, int Z, double Outset, boolean[] SidesToRender, boolean RenderSideFlag) {
        if (SidesToRender == null || SidesToRender[Directions.NegY.ordinal()] == RenderSideFlag) {
            this.SetTint(0.5);
            Render.AddVertex((double)(X + 1) - this.SideMinH, (double)Y - Outset, (double)(Z + 1) - this.SideMinV, this.TextureMinU, this.TextureMaxV);
            Render.AddVertex((double)(X + 1) - this.SideMaxH, (double)Y - Outset, (double)(Z + 1) - this.SideMinV, this.TextureMaxU, this.TextureMaxV);
            Render.AddVertex((double)(X + 1) - this.SideMaxH, (double)Y - Outset, (double)(Z + 1) - this.SideMaxV, this.TextureMaxU, this.TextureMinV);
            Render.AddVertex((double)(X + 1) - this.SideMinH, (double)Y - Outset, (double)(Z + 1) - this.SideMaxV, this.TextureMinU, this.TextureMinV);
        }
        if (SidesToRender == null || SidesToRender[Directions.PosY.ordinal()] == RenderSideFlag) {
            this.SetTint(1.0);
            Render.AddVertex((double)X + this.SideMinH, (double)(Y + 1) + Outset, (double)(Z + 1) - this.SideMinV, this.TextureMinU, this.TextureMaxV);
            Render.AddVertex((double)X + this.SideMaxH, (double)(Y + 1) + Outset, (double)(Z + 1) - this.SideMinV, this.TextureMaxU, this.TextureMaxV);
            Render.AddVertex((double)X + this.SideMaxH, (double)(Y + 1) + Outset, (double)(Z + 1) - this.SideMaxV, this.TextureMaxU, this.TextureMinV);
            Render.AddVertex((double)X + this.SideMinH, (double)(Y + 1) + Outset, (double)(Z + 1) - this.SideMaxV, this.TextureMinU, this.TextureMinV);
        }
        if (SidesToRender == null || SidesToRender[Directions.NegZ.ordinal()] == RenderSideFlag) {
            this.SetTint(0.8);
            Render.AddVertex((double)(X + 1) - this.SideMaxH, (double)Y + this.SideMaxV, (double)Z - Outset, this.TextureMinU, this.TextureMinV);
            Render.AddVertex((double)(X + 1) - this.SideMinH, (double)Y + this.SideMaxV, (double)Z - Outset, this.TextureMaxU, this.TextureMinV);
            Render.AddVertex((double)(X + 1) - this.SideMinH, (double)Y + this.SideMinV, (double)Z - Outset, this.TextureMaxU, this.TextureMaxV);
            Render.AddVertex((double)(X + 1) - this.SideMaxH, (double)Y + this.SideMinV, (double)Z - Outset, this.TextureMinU, this.TextureMaxV);
        }
        if (SidesToRender == null || SidesToRender[Directions.PosZ.ordinal()] == RenderSideFlag) {
            this.SetTint(0.8);
            Render.AddVertex((double)X + this.SideMinH, (double)Y + this.SideMinV, (double)(Z + 1) + Outset, this.TextureMinU, this.TextureMaxV);
            Render.AddVertex((double)X + this.SideMaxH, (double)Y + this.SideMinV, (double)(Z + 1) + Outset, this.TextureMaxU, this.TextureMaxV);
            Render.AddVertex((double)X + this.SideMaxH, (double)Y + this.SideMaxV, (double)(Z + 1) + Outset, this.TextureMaxU, this.TextureMinV);
            Render.AddVertex((double)X + this.SideMinH, (double)Y + this.SideMaxV, (double)(Z + 1) + Outset, this.TextureMinU, this.TextureMinV);
        }
        if (SidesToRender == null || SidesToRender[Directions.NegX.ordinal()] == RenderSideFlag) {
            this.SetTint(0.6);
            Render.AddVertex((double)X - Outset, (double)Y + this.SideMinV, (double)Z + this.SideMinH, this.TextureMinU, this.TextureMaxV);
            Render.AddVertex((double)X - Outset, (double)Y + this.SideMinV, (double)Z + this.SideMaxH, this.TextureMaxU, this.TextureMaxV);
            Render.AddVertex((double)X - Outset, (double)Y + this.SideMaxV, (double)Z + this.SideMaxH, this.TextureMaxU, this.TextureMinV);
            Render.AddVertex((double)X - Outset, (double)Y + this.SideMaxV, (double)Z + this.SideMinH, this.TextureMinU, this.TextureMinV);
        }
        if (SidesToRender == null || SidesToRender[Directions.PosX.ordinal()] == RenderSideFlag) {
            this.SetTint(0.6);
            Render.AddVertex((double)(X + 1) + Outset, (double)Y + this.SideMaxV, (double)(Z + 1) - this.SideMaxH, this.TextureMinU, this.TextureMinV);
            Render.AddVertex((double)(X + 1) + Outset, (double)Y + this.SideMaxV, (double)(Z + 1) - this.SideMinH, this.TextureMaxU, this.TextureMinV);
            Render.AddVertex((double)(X + 1) + Outset, (double)Y + this.SideMinV, (double)(Z + 1) - this.SideMinH, this.TextureMaxU, this.TextureMaxV);
            Render.AddVertex((double)(X + 1) + Outset, (double)Y + this.SideMinV, (double)(Z + 1) - this.SideMaxH, this.TextureMinU, this.TextureMaxV);
        }
    }
}

