/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.core.interop.mod;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.IChickenChunkLoader;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.lib.vec.BlockCoord;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ChickenChunkLoader
implements IChickenChunkLoader {
    private String owner;
    private BlockCoord coords;
    private Collection<ChunkCoordIntPair> chunks;
    private World world;

    public ChickenChunkLoader(TileChunkLoaderBase tile) {
        this.owner = tile.getOwner();
        this.coords = tile.getPosition();
        this.chunks = tile.getChunks();
        this.world = tile.func_145831_w();
    }

    public ChickenChunkLoader(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("owner", this.owner);
        NBTTagCompound coord = new NBTTagCompound();
        coord.func_74768_a("X", this.coords.x);
        coord.func_74768_a("Y", this.coords.y);
        coord.func_74768_a("Z", this.coords.z);
        tag.func_74782_a("coords", (NBTBase)coord);
        tag.func_74768_a("dimension", this.world.func_72912_H().func_76076_i());
        NBTTagList chunk = new NBTTagList();
        for (ChunkCoordIntPair pair : this.chunks) {
            chunk.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pair.field_77276_a, pair.field_77275_b}));
        }
        tag.func_74782_a("chunks", (NBTBase)chunk);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.owner = tag.func_74779_i("owner");
        NBTTagCompound coord = tag.func_74775_l("coords");
        this.coords = new BlockCoord(coord.func_74762_e("X"), coord.func_74762_e("Y"), coord.func_74762_e("Z"));
        this.world = DimensionManager.getWorld((int)tag.func_74762_e("dimension"));
        HashSet<ChunkCoordIntPair> chunk = new HashSet<ChunkCoordIntPair>();
        NBTTagList list = tag.func_150295_c("chunks", 4);
        int size = list.func_74745_c();
        for (int i = 0; i < size; ++i) {
            int[] array = list.func_150306_c(i);
            chunk.add(new ChunkCoordIntPair(array[0], array[1]));
        }
        this.chunks = chunk;
    }

    public String getOwner() {
        return this.owner;
    }

    public Object getMod() {
        return ChickenChunks.instance;
    }

    public World getWorld() {
        return null;
    }

    public BlockCoord getPosition() {
        return this.coords;
    }

    public void deactivate() {
    }

    public void activate() {
    }

    public Collection<ChunkCoordIntPair> getChunks() {
        return this.chunks;
    }
}

