/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.core;

import java.util.ArrayList;
import me.planetguy.remaininmotion.api.ICloseable;
import me.planetguy.remaininmotion.api.ICloseableFactory;
import net.minecraft.tileentity.TileEntity;

public class Closeables {
    static ArrayList<ClassEntry> classesRegistered = new ArrayList();

    public static void register(ICloseableFactory closeable) {
        ClassEntry e = new ClassEntry();
        e.targetClass = closeable.validClass();
        e.icf = closeable;
        classesRegistered.add(e);
    }

    public static ICloseable getCloseable(TileEntity entity) {
        if (entity != null) {
            for (ClassEntry e : classesRegistered) {
                ICloseable closeable;
                if (!e.matches(entity) || (closeable = e.icf.retrieve(entity)) == null) continue;
                return closeable;
            }
        }
        return null;
    }

    private static class ClassEntry {
        Class targetClass;
        ICloseableFactory icf;

        private ClassEntry() {
        }

        public boolean matches(Object o) {
            return o != null && this.targetClass.isAssignableFrom(o.getClass());
        }
    }
}

