/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.carriage;

import me.planetguy.lib.util.Lang;
import me.planetguy.remaininmotion.carriage.TileEntityCarriage;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.motion.BlacklistManager;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPlatformCarriage
extends TileEntityCarriage {
    public void FailBecauseOverburdened() throws CarriageMotionException {
        throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.overburdened").replace("##BURDEN##", RiMConfiguration.Carriage.MaxPlatformBurden + ""));
    }

    @Override
    public void fillPackage(CarriagePackage pkg) throws CarriageMotionException {
        BlockRecordSet checked = new BlockRecordSet();
        checked.add(pkg.driveRecord);
        BlockRecordSet todo = new BlockRecordSet();
        todo.add(pkg.AnchorRecord);
        int positionsCarried = 0;
        while (!todo.isEmpty()) {
            BlockRecord inProgress = (BlockRecord)todo.pollFirst();
            if (this.canAdd(inProgress, positionsCarried)) {
                ++positionsCarried;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    BlockRecord neighbour;
                    if (inProgress == pkg.AnchorRecord && this.SideClosed[dir.ordinal()] || checked.contains(neighbour = new BlockRecord(inProgress).shift(dir))) continue;
                    todo.add(neighbour);
                }
                inProgress.Identify(this.field_145850_b);
                pkg.AddBlock(inProgress);
            } else {
                pkg.AddPotentialObstruction(inProgress);
            }
            checked.add(inProgress);
        }
    }

    private boolean canAdd(BlockRecord record, int count) {
        if (this.field_145850_b.func_147437_c(record.X, record.Y, record.Z)) {
            return false;
        }
        if (count > RiMConfiguration.Carriage.MaxPlatformBurden) {
            return false;
        }
        return !BlacklistManager.blacklistSoft.lookup(this.field_145850_b, record.X, record.Y, record.Z);
    }
}

