/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.carriage;

import me.planetguy.remaininmotion.api.ConnectabilityState;
import me.planetguy.remaininmotion.api.ICloseable;
import me.planetguy.remaininmotion.api.Moveable;
import me.planetguy.remaininmotion.base.BlockRiM;
import me.planetguy.remaininmotion.base.TileEntityCamouflageable;
import me.planetguy.remaininmotion.carriage.ItemCarriage;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.transformations.ArrayRotator;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityCarriage
extends TileEntityCamouflageable
implements Moveable,
ICloseable {
    public boolean[] SideClosed = new boolean[Directions.values().length];

    public boolean canUpdate() {
        return false;
    }

    public void ToggleSide(int Side2, boolean Sneaking) {
        if (Sneaking) {
            Side2 = Directions.values()[Side2].opposite().ordinal();
        }
        this.SideClosed[Side2] = !this.SideClosed[Side2];
        this.Propagate();
    }

    @Override
    public ConnectabilityState isSideClosed(int side) {
        return this.treatSideAsClosed(side) ? ConnectabilityState.CLOSED : ConnectabilityState.OPEN;
    }

    public boolean treatSideAsClosed(int side) {
        return this.SideClosed[side];
    }

    @Override
    public void EmitDrops(BlockRiM Block2, int Meta) {
        this.EmitDrop(Block2, ItemCarriage.Stack(Meta, Block.func_149682_b((Block)this.getDecoration()), this.getDecorationMeta()));
    }

    @Override
    public void ReadCommonRecord(NBTTagCompound TagCompound) {
        for (int Index = 0; Index < this.SideClosed.length; ++Index) {
            this.SideClosed[Index] = TagCompound.func_74767_n("SideClosed" + Index);
        }
        this.Decoration = Block.func_149729_e((int)TagCompound.func_74762_e("DecorationId"));
        this.DecorationMeta = TagCompound.func_74762_e("DecorationMeta");
    }

    @Override
    public void WriteCommonRecord(NBTTagCompound TagCompound) {
        for (int Index = 0; Index < this.SideClosed.length; ++Index) {
            TagCompound.func_74757_a("SideClosed" + Index, this.SideClosed[Index]);
        }
        TagCompound.func_74768_a("DecorationId", Block.func_149682_b((Block)this.Decoration));
        TagCompound.func_74768_a("DecorationMeta", this.DecorationMeta);
    }

    @Override
    public abstract void fillPackage(CarriagePackage var1) throws CarriageMotionException;

    @Override
    public void rotateSpecial(ForgeDirection axis) {
        ArrayRotator.rotate(this.SideClosed, axis);
    }
}

