/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import cofh.api.world.IFeatureGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.common.BiomeDictionary;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeRegistry;

public class WorldGenLake
implements IFeatureGenerator {
    private Block block;
    private int frequency;
    private WorldGenLakes lakeGen;

    public WorldGenLake(Block block, int frequency) {
        this.block = block;
        this.frequency = frequency;
        this.lakeGen = new WorldGenLakes(block);
    }

    public String getFeatureName() {
        return "Artifice: " + this.block.func_149739_a() + " Lakes";
    }

    public boolean generateFeature(Random rand, int chunkX, int chunkZ, World world, boolean newGen) {
        int dim = world.field_73011_w.field_76574_g;
        if (ArtificeRegistry.getDimensionBlacklist().contains(dim)) {
            return false;
        }
        String worldType = world.field_73011_w.field_76577_b.func_77127_a();
        if (ArtificeRegistry.getWorldTypeBlacklist().contains(worldType)) {
            return false;
        }
        int total = this.frequency >= 100 ? (rand.nextInt(100) < Math.abs(this.frequency % (int)Math.pow(10.0, (int)Math.log10(this.frequency))) ? this.frequency / 100 + 1 : this.frequency / 100) : (rand.nextInt(100) < this.frequency ? 0 : 1);
        for (int j = 0; j < total; ++j) {
            if (rand.nextInt(100) > 10) {
                return true;
            }
            int x = chunkX * 16 + rand.nextInt(16);
            int z = chunkZ * 16 + rand.nextInt(16);
            int y = world.func_72976_f(x, z);
            BiomeGenBase biome = world.func_72807_a(x, z);
            if (!this.block.equals(ArtificeBlocks.blockOil) || !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) continue;
            this.lakeGen.func_76484_a(world, rand, x, y, z);
        }
        return true;
    }
}

