/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.util.BlockCoord;

public class VolcanoHelper {
    public static boolean canGenHere(World world, BlockCoord b) {
        if ((double)VolcanoHelper.getComposition(world, b, 32) > 0.25) {
            return false;
        }
        return !((double)VolcanoHelper.getComposition(world, b, -32) < 0.65);
    }

    public static float getComposition(World world, BlockCoord b, int yDistance) {
        BlockCoord c = b.copy();
        int solidCount = 0;
        int nonSolidCount = 0;
        while (c.y < b.y + yDistance) {
            if (c.getBlock((IBlockAccess)world).func_149662_c()) {
                ++solidCount;
            } else {
                ++nonSolidCount;
            }
            for (BlockCoord n : c.getAdjacent()) {
                if (n.getBlock((IBlockAccess)world).func_149662_c()) {
                    ++solidCount;
                    continue;
                }
                ++nonSolidCount;
            }
            if (yDistance > 0) {
                ++c.y;
                continue;
            }
            --c.y;
        }
        return (float)solidCount / ((float)nonSolidCount + (float)solidCount);
    }

    public static int getHighestSolidOrFillBlock(World world, int x, int z) {
        int y = 255;
        Block b = world.func_147439_a(x, y, z);
        while (y > 0 && !b.func_149662_c() && b != Blocks.field_150353_l && b != Blocks.field_150356_k && !b.isWood((IBlockAccess)world, x, y, z) && b != ArtificeBlocks.blockCharredLog) {
            b = world.func_147439_a(x, --y, z);
        }
        return y;
    }

    public static boolean isVolcanicBlock(Block b) {
        return b == ArtificeBlocks.blockBasalt || b == ArtificeBlocks.blockTephra || b == ArtificeBlocks.blockCharredLog;
    }

    public static boolean isVolcanicFill(Block b) {
        return b == Blocks.field_150343_Z || b == Blocks.field_150353_l || b == Blocks.field_150356_k;
    }

    public static void setVolcanoBlock(World world, BlockCoord coord) {
        Random rand = world.field_73012_v;
        for (BlockCoord t : coord.getAdjacent()) {
            if (t.isAir((IBlockAccess)world) || !t.getBlock((IBlockAccess)world).isWood((IBlockAccess)world, t.x, t.y, t.z)) continue;
            VolcanoHelper.charTree(world, t);
        }
        if (coord.getBlock((IBlockAccess)world) != Blocks.field_150357_h) {
            coord.setBlock(world, ArtificeBlocks.blockBasalt, rand.nextInt(4) == 0 ? 1 : 0, false);
        }
    }

    public static void setVolcanoTephra(World world, BlockCoord coord) {
        Random rand = world.field_73012_v;
        for (BlockCoord t : coord.getAdjacent()) {
            if (t.isAir((IBlockAccess)world) || !t.getBlock((IBlockAccess)world).isWood((IBlockAccess)world, t.x, t.y, t.z)) continue;
            VolcanoHelper.charTree(world, t);
        }
        if (coord.getBlock((IBlockAccess)world) != Blocks.field_150357_h) {
            coord.setBlock(world, (Block)ArtificeBlocks.blockTephra, rand.nextInt(4) == 0 ? 0 : 1, false);
        }
    }

    public static void setVolcanoFill(World world, BlockCoord coord, boolean active) {
        if (coord.getBlock((IBlockAccess)world) != Blocks.field_150357_h) {
            coord.setBlock(world, active ? Blocks.field_150353_l : Blocks.field_150343_Z, 0, false);
        }
    }

    public static boolean isReplaceable(World world, BlockCoord b) {
        Block k = b.getBlock((IBlockAccess)world);
        return b.y > 0 && b.y < 256 && (b.isAir((IBlockAccess)world) || !k.func_149662_c() && !VolcanoHelper.isVolcanicFill(k));
    }

    public static List<BlockCoord> getOpenSides(World world, BlockCoord b) {
        ArrayList<BlockCoord> open = new ArrayList<BlockCoord>();
        for (BlockCoord t : b.getAdjacent()) {
            if (t.y > b.y) continue;
            if (VolcanoHelper.isReplaceable(world, t)) {
                open.add(t);
                continue;
            }
            if (!VolcanoHelper.isVolcanicFill(t.getBlock((IBlockAccess)world))) continue;
            for (BlockCoord n : t.getAdjacent()) {
                if (n == t || n.y > t.y || open.contains(n) || !VolcanoHelper.isReplaceable(world, n)) continue;
                open.add(n);
            }
        }
        return open;
    }

    public static BlockCoord snapToHighest(World world, BlockCoord b) {
        b.y = VolcanoHelper.getHighestSolidOrFillBlock(world, b.x, b.z);
        return b;
    }

    public static BlockCoord get2dINVERSEDistributedCoord(World world, BlockCoord origin, int maxDistance) {
        double distance;
        Random rand = world.field_73012_v;
        while (!((distance = rand.nextDouble() * (double)maxDistance) > 0.0) || !(rand.nextDouble() * (double)maxDistance <= (double)(maxDistance / 8) + (double)maxDistance / distance)) {
        }
        BlockCoord b = origin.copy();
        double xDistance = rand.nextDouble() * distance * (double)(rand.nextBoolean() ? -1 : 1);
        double zDistance = Math.sqrt(Math.pow(distance, 2.0) - Math.pow(xDistance, 2.0)) * (double)(rand.nextBoolean() ? -1 : 1);
        b.x = (int)((double)b.x + (xDistance > 0.0 ? Math.floor(xDistance) : Math.ceil(xDistance)));
        b.z = (int)((double)b.z + (zDistance > 0.0 ? Math.floor(zDistance) : Math.ceil(zDistance)));
        return b;
    }

    public static BlockCoord get2dSINDistributedCoord(World world, BlockCoord origin, int maxDistance) {
        double point;
        double distance;
        Random rand = world.field_73012_v;
        do {
            if (!Double.isNaN(point = 2.0 + Math.sin(((distance = rand.nextDouble() * (double)maxDistance) + rand.nextDouble() * 3.0) / (double)(maxDistance / 4)))) continue;
            point = 1.0;
        } while (!(distance > 0.0) || !(rand.nextDouble() * 3.0 <= point));
        BlockCoord b = origin.copy();
        double xDistance = rand.nextDouble() * distance * (double)(rand.nextBoolean() ? -1 : 1);
        double zDistance = Math.sqrt(Math.pow(distance, 2.0) - Math.pow(xDistance, 2.0)) * (double)(rand.nextBoolean() ? -1 : 1);
        b.x = (int)((double)b.x + (xDistance > 0.0 ? Math.floor(xDistance) : Math.ceil(xDistance)));
        b.z = (int)((double)b.z + (zDistance > 0.0 ? Math.floor(zDistance) : Math.ceil(zDistance)));
        return b;
    }

    public static void charTree(World world, BlockCoord start) {
        start.setBlock(world, (Block)ArtificeBlocks.blockCharredLog, start.getMeta((IBlockAccess)world), false);
        for (BlockCoord b : start.getRadiusBlocks(2)) {
            if (b.getBlock((IBlockAccess)world).isWood((IBlockAccess)world, b.x, b.y, b.z)) {
                VolcanoHelper.charTree(world, b);
                continue;
            }
            if (!b.getBlock((IBlockAccess)world).isLeaves((IBlockAccess)world, b.x, b.y, b.z)) continue;
            b.setBlock(world, Blocks.field_150350_a, 0, false);
        }
    }
}

