/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.util;

import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.tile.IHeatReceiver;
import shukaro.artifice.tile.TileFurnaceWrapper;
import shukaro.artifice.util.BlockCoord;

public class MiscUtils {
    public static <T> void shuffleArray(T[] array) {
        for (int i = array.length; i > 1; --i) {
            T temp = array[i - 1];
            int randIx = (int)(Math.random() * (double)i);
            array[i - 1] = array[randIx];
            array[randIx] = temp;
        }
    }

    public static int randWithin50(Random rand, int input) {
        if (input > 1) {
            return input + rand.nextInt(input / 2) - rand.nextInt(input / 2);
        }
        return 1;
    }

    public static void dropStack(World world, int x, int y, int z, ItemStack itemstack) {
        while (itemstack.field_77994_a > 0) {
            float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            int amountToDrop = Math.min(world.field_73012_v.nextInt(21) + 10, itemstack.field_77994_a);
            EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), itemstack.func_77979_a(amountToDrop));
            float motionMultiplier = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void addChatMessage(EntityPlayer player, String message) {
        player.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public static IHeatReceiver getHeatReceiverNeighbor(World world, int x, int y, int z) {
        Integer[] sides = new Integer[]{0, 1, 2, 3, 4, 5};
        MiscUtils.shuffleArray(sides);
        Integer[] arr$ = sides;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int i = arr$[i$];
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[sides[i]];
            TileEntity te = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (te instanceof TileEntityFurnace) {
                return new TileFurnaceWrapper((TileEntityFurnace)te);
            }
            if (!(te instanceof IHeatReceiver)) continue;
            return (IHeatReceiver)te;
        }
        return null;
    }

    public static int provideEnergyToNeighbors(int amount, World world, int x, int y, int z) {
        Integer[] sides = new Integer[]{0, 1, 2, 3, 4, 5};
        MiscUtils.shuffleArray(sides);
        Integer[] arr$ = sides;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IEnergyReceiver rec;
            int i = arr$[i$];
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[sides[i]];
            TileEntity te = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (!(te instanceof IEnergyReceiver) || !(rec = (IEnergyReceiver)te).canConnectEnergy(dir.getOpposite())) continue;
            amount -= rec.receiveEnergy(dir.getOpposite(), amount, false);
        }
        return amount;
    }

    public static <T extends TileEntity> List<T> getAdjoinedTileEntities(Class<T> teClass, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null) {
            ArrayList<TileEntity> teList = new ArrayList<TileEntity>();
            ArrayList<BlockCoord> done = new ArrayList<BlockCoord>();
            ArrayList<TileEntity> adjoined = new ArrayList<TileEntity>();
            teList.add(te);
            while (!teList.isEmpty()) {
                te = (TileEntity)teList.remove(0);
                done.add(new BlockCoord(te.field_145851_c, te.field_145848_d, te.field_145849_e));
                if (!teClass.isInstance(te)) continue;
                adjoined.add(te);
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    if (!world.func_72899_e(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) || (te = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) == null || done.contains(new BlockCoord(te.field_145851_c, te.field_145848_d, te.field_145849_e))) continue;
                    teList.add(te);
                }
            }
            return adjoined;
        }
        return null;
    }
}

