/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.tile;

import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.tile.IHeatReceiver;

public class TileFurnaceWrapper
implements IHeatReceiver {
    private TileEntityFurnace furnace;

    public TileFurnaceWrapper(TileEntityFurnace furnace) {
        this.furnace = furnace;
    }

    public boolean canSmelt() {
        if (this.furnace.func_70301_a(0) == null) {
            return false;
        }
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.furnace.func_70301_a(0));
        if (output == null) {
            return false;
        }
        if (this.furnace.func_70301_a(2) == null) {
            return true;
        }
        if (!this.furnace.func_70301_a(2).func_77969_a(output)) {
            return false;
        }
        int result = this.furnace.func_70301_a((int)2).field_77994_a + output.field_77994_a;
        return result <= this.furnace.func_70297_j_() && result <= output.func_77976_d();
    }

    @Override
    public int receiveHeat(int amount) {
        if (!this.canSmelt()) {
            return 0;
        }
        int received = Math.min(this.getMaxHeat() - this.getHeat(), amount);
        this.furnace.field_145956_a += received / ArtificeConfig.RFperFurnaceHeat;
        this.furnace.field_145961_j = Math.min(this.furnace.field_145961_j, 199);
        BlockFurnace.func_149931_a((this.furnace.field_145961_j > 0 ? 1 : 0) != 0, (World)this.furnace.func_145831_w(), (int)this.furnace.field_145851_c, (int)this.furnace.field_145848_d, (int)this.furnace.field_145849_e);
        return received;
    }

    @Override
    public int getHeat() {
        return this.furnace.field_145956_a * ArtificeConfig.RFperFurnaceHeat;
    }

    @Override
    public int getMaxHeat() {
        return 1600;
    }
}

