/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.tile;

import cofh.lib.util.helpers.MathHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLogic
extends TileEntity {
    public SideState[] sides = new SideState[6];
    public int power = 0;

    public TileEntityLogic() {
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = SideState.DISABLED;
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        boolean changed;
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int power = 0;
        if (meta == 0) {
            boolean hasInput = false;
            for (int i = 0; i < 6; ++i) {
                if (this.sides[i] != SideState.POSITIVE && this.sides[i] != SideState.NEGATIVE) continue;
                hasInput = true;
                break;
            }
            boolean powered = hasInput;
            for (int i = 0; i < 6; ++i) {
                if (this.sides[i] == SideState.POSITIVE && this.getIndirectPowerFrom(i) == 0) {
                    powered = false;
                    continue;
                }
                if (this.sides[i] != SideState.NEGATIVE || this.getIndirectPowerFrom(i) <= 0) continue;
                powered = false;
            }
            power = powered ? 15 : 0;
        } else {
            for (int i = 0; i < 6; ++i) {
                if (this.sides[i] == SideState.POSITIVE) {
                    power += this.getIndirectPowerFrom(i);
                }
                if (this.sides[i] != SideState.NEGATIVE) continue;
                power -= this.getIndirectPowerFrom(i);
            }
            power = MathHelper.clampI((int)power, (int)0, (int)15);
        }
        boolean bl = changed = this.power != power;
        if (changed) {
            this.power = power;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    private int getIndirectPowerFrom(int side) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        return this.field_145850_b.func_72878_l(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir.ordinal());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        int[] sidesInt = tag.func_74759_k("sides");
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = SideState.values()[sidesInt[i]];
        }
        this.power = tag.func_74762_e("power");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        int[] sidesInt = new int[6];
        for (int i = 0; i < 6; ++i) {
            sidesInt[i] = this.sides[i].ordinal();
        }
        tag.func_74783_a("sides", sidesInt);
        tag.func_74768_a("power", this.power);
    }

    public static enum SideState {
        DISABLED,
        OUTPUT,
        POSITIVE,
        NEGATIVE;

    }
}

