/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.world;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.block.ItemBlockArtifice;
import shukaro.artifice.render.TextureHandler;

public class BlockEnderOre
extends Block {
    public IIcon icon;
    public boolean glowing;
    private Random rand = new Random();

    public BlockEnderOre(boolean glowing) {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(ArtificeCore.worldTab);
        if (glowing) {
            this.func_149663_c("artifice.enderore.glowing");
        } else {
            this.func_149663_c("artifice.enderore");
        }
        this.setHarvestLevel("pickaxe", 2);
        this.glowing = glowing;
        if (this.glowing) {
            this.func_149715_a(0.625f);
            this.func_149675_a(true);
        }
        GameRegistry.registerBlock((Block)this, ItemBlockArtifice.class, (String)this.func_149739_a());
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int fortune) {
        super.func_149636_a(world, entityplayer, x, y, z, fortune);
        if (!world.field_72995_K && world.field_73012_v.nextInt(100) < 20 && ArtificeConfig.spawnEndermen && !EnchantmentHelper.func_77502_d((EntityLivingBase)entityplayer)) {
            int tries = world.field_73012_v.nextInt(20);
            for (int i = 0; i < tries; ++i) {
                int spawnZ;
                int spawnY;
                int spawnX = x + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3);
                if (!this.canSpawnEnder(world, spawnX, spawnY = y + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3), spawnZ = z + world.field_73012_v.nextInt(3) - world.field_73012_v.nextInt(3))) continue;
                EntityEnderman ender = new EntityEnderman(world);
                ender.func_70012_b((double)spawnX + world.field_73012_v.nextDouble(), (double)spawnY + world.field_73012_v.nextDouble(), (double)spawnZ + world.field_73012_v.nextDouble(), world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
                world.func_72838_d((Entity)ender);
                ender.func_70656_aK();
                ender.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
                break;
            }
        }
    }

    private boolean canSpawnEnder(World world, int x, int y, int z) {
        return !(world.func_147439_a(x, y, z) != null && !world.func_147437_c(x, y, z) || world.func_147439_a(x, y + 1, z) != null && !world.func_147437_c(x, y + 1, z) || world.func_147439_a(x, y + 2, z) != null && !world.func_147437_c(x, y + 2, z));
    }

    public int func_149738_a(World p_149738_1_) {
        return 30;
    }

    private void activate(World world, int x, int y, int z) {
        this.sparkle(world, x, y, z);
        if (!this.glowing) {
            world.func_147449_b(x, y, z, (Block)ArtificeBlocks.blockEnderOreGlowing);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.glowing) {
            world.func_147449_b(x, y, z, (Block)ArtificeBlocks.blockEnderOre);
        }
    }

    private void sparkle(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            double dx = (double)x + 0.5 + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
            double dy = (double)y + 0.5 + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
            double dz = (double)z + 0.5 + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble();
            world.func_72869_a("portal", dx, dy, dz, world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.glowing) {
            this.sparkle(world, x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        this.activate(world, x, y, z);
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.activate(world, x, y, z);
        super.func_149724_b(world, x, y, z, entity);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.activate(world, x, y, z);
        super.func_149699_a(world, x, y, z, player);
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        return 2 + rand.nextInt(3) + rand.nextInt(fortune + 1);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return ArtificeItems.itemResource;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public int func_149692_a(int meta) {
        return 2;
    }

    public int getExpDrop(IBlockAccess world, int meta, int fortune) {
        if (this.func_149650_a(meta, this.rand, fortune) != Item.func_150898_a((Block)this)) {
            return 1 + this.rand.nextInt(5);
        }
        return 0;
    }

    public ItemStack func_149644_j(int p_149644_1_) {
        return new ItemStack((Block)ArtificeBlocks.blockEnderOre);
    }

    public void func_149651_a(IIconRegister reg) {
        this.icon = TextureHandler.registerIcon(reg, "oreEnder", "ores/ender");
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icon;
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        return this.icon;
    }

    public void func_149666_a(Item i, CreativeTabs tabs, List list) {
        if (!this.glowing) {
            list.add(new ItemStack(i, 1, 0));
        }
    }
}

