/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.frame;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.block.frame.BlockFrame;
import shukaro.artifice.block.frame.ItemBlockFrame;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.util.BlockCoord;

public class BlockFrameScaffold
extends BlockFrame {
    private static final ForgeDirection[] sides = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.DOWN};
    private IIcon[] icons = new IIcon[ArtificeConfig.tiers.length];
    private IIcon[] sideIcons = new IIcon[ArtificeConfig.tiers.length];

    public BlockFrameScaffold() {
        this.func_149663_c("artifice.scaffold");
        this.func_149676_a(0.01f, 0.01f, 0.01f, 0.99f, 0.99f, 0.99f);
        GameRegistry.registerBlock((Block)this, ItemBlockFrame.class, (String)this.func_149739_a());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        TextureHandler.registerConnectedTexture(reg, this, 0, 0, "basic", "scaffold");
        TextureHandler.registerConnectedTexture(reg, this, 0, 1, "basic", "scaffold");
        this.icons[0] = TextureHandler.getConnectedTexture((Block)this, (int)0, (int)1).icon;
        TextureHandler.registerConnectedTexture(reg, this, 1, 0, "reinforced", "scaffold");
        TextureHandler.registerConnectedTexture(reg, this, 1, 1, "reinforced", "scaffold");
        this.icons[1] = TextureHandler.getConnectedTexture((Block)this, (int)1, (int)1).icon;
        TextureHandler.registerConnectedTexture(reg, this, 2, 0, "industrial", "scaffold");
        TextureHandler.registerConnectedTexture(reg, this, 2, 1, "industrial", "scaffold");
        this.icons[2] = TextureHandler.getConnectedTexture((Block)this, (int)2, (int)1).icon;
        TextureHandler.registerConnectedTexture(reg, this, 3, 0, "advanced", "scaffold");
        TextureHandler.registerConnectedTexture(reg, this, 3, 1, "advanced", "scaffold");
        this.icons[3] = TextureHandler.getConnectedTexture((Block)this, (int)3, (int)1).icon;
        for (int i = 0; i < ArtificeConfig.tiers.length; ++i) {
            this.sideIcons[i] = TextureHandler.registerIcon(reg, ArtificeConfig.tiers[i].toLowerCase(Locale.ENGLISH), "scaffold/sides");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= ArtificeConfig.tiers.length) {
            meta = 0;
        }
        if (side == 0 || side == 1) {
            return this.icons[meta];
        }
        return this.sideIcons[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        if (meta > ArtificeConfig.tiers.length) {
            meta = 0;
        }
        if (side == 0 || side == 1) {
            return this.func_149691_a(side, meta);
        }
        return this.sideIcons[access.func_72805_g(x, y, z)];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public int func_149645_b() {
        return ArtificeConfig.frameRenderID;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side.ordinal() < 2;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        float shrinkAmount = 0.022222223f;
        if (entity.field_70121_D.field_72338_b >= (double)((float)y + (1.0f - shrinkAmount)) || entity.field_70121_D.field_72337_e <= (double)((float)y + shrinkAmount)) {
            return;
        }
        entity.field_70143_R = 0.0f;
        if (entity.field_70123_F) {
            entity.field_70181_x = 0.2;
        } else if (entity.func_70093_af()) {
            double diff = entity.field_70167_r - entity.field_70163_u;
            entity.field_70121_D.field_72338_b += diff;
            entity.field_70121_D.field_72337_e += diff;
            entity.field_70163_u = entity.field_70167_r;
        } else {
            entity.field_70181_x = -0.12;
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float shrinkAmount = 0.125f;
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B + (double)shrinkAmount), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D + (double)shrinkAmount), (double)((double)x + this.field_149755_E - (double)shrinkAmount), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G - (double)shrinkAmount));
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack held = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (held == null || held.func_77973_b() == null || Block.func_149634_a((Item)held.func_77973_b()) == null) {
            return;
        }
        Block hb = Block.func_149634_a((Item)held.func_77973_b());
        if (held != null && hb != null && hb.equals((Object)this) && held.func_77960_j() == world.func_72805_g(x, y, z)) {
            while (world.func_147439_a(x, y, z).equals((Object)this)) {
                ++y;
            }
            if (this.checkStay(world, x, y, z, held.func_77960_j()) && world.func_147437_c(x, y, z)) {
                world.func_147465_d(x, y, z, (Block)this, held.func_77960_j(), 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                    if (held.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                }
            }
        }
    }

    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack stack) {
        return this.checkStay(world, x, y, z, stack.func_77960_j());
    }

    public int getOverhang(int meta) {
        switch (meta) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.checkStay(world, x, y, z, world.func_72805_g(x, y, z));
    }

    private boolean checkStay(World world, int x, int y, int z, int meta) {
        BlockCoord c = new BlockCoord(x, y, z);
        if (this.isRooted(world, x, y, z, meta)) {
            return true;
        }
        for (ForgeDirection d : sides) {
            BlockCoord t = c.copy().offset(d.ordinal());
            if (!(t.getBlock((IBlockAccess)world) instanceof BlockFrameScaffold)) continue;
            if (t.blockEquals(world, (Block)this, meta)) {
                if (this.isRooted(world, t.x, t.y, t.z, meta)) {
                    return true;
                }
                for (BlockCoord match : c.getRadiusMatches(world, this.getOverhang(meta), this, meta)) {
                    if (!this.isRooted(world, match.x, match.y, match.z, meta) || !c.isConnected(world, match, this, meta) || !(c.getDistance(match) <= (float)this.getOverhang(meta))) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isRooted(World world, int x, int y, int z, int meta) {
        for (int i = y - 1; i > 0; --i) {
            if (world.isSideSolid(x, i, z, ForgeDirection.UP)) {
                if (world.func_147439_a(x, i, z).equals((Object)this)) {
                    if (world.func_72805_g(x, i, z) == meta) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }
}

