/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import cofh.api.world.IFeatureGenerator;
import cofh.core.world.WorldHandler;
import net.minecraft.block.Block;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.world.WorldGenCave;
import shukaro.artifice.world.WorldGenCluster;
import shukaro.artifice.world.WorldGenDesert;
import shukaro.artifice.world.WorldGenFlowers;
import shukaro.artifice.world.WorldGenLake;
import shukaro.artifice.world.WorldGenLayer;
import shukaro.artifice.world.WorldGenLily;
import shukaro.artifice.world.WorldGenSulfur;

public class ArtificeWorld {
    public static void initWorldGen() {
        int i;
        if (ArtificeConfig.oilLakeGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenLake(ArtificeBlocks.blockOil, ArtificeConfig.oilLakeFrequency));
        }
        if (ArtificeConfig.sulfurGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenSulfur(ArtificeBlocks.blockSulfur, 0, ArtificeConfig.sulfurSize, ArtificeConfig.sulfurFrequency));
        }
        if (ArtificeConfig.niterGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenDesert((Block)ArtificeBlocks.blockNiter, 0, ArtificeConfig.niterSize, ArtificeConfig.niterFrequency));
        }
        if (ArtificeConfig.uraniumOreGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenCluster(ArtificeBlocks.blockUranium, 0, ArtificeConfig.uraniumOreMinHeight, ArtificeConfig.uraniumOreMaxHeight, ArtificeConfig.uraniumOreSize, ArtificeConfig.uraniumOreFrequency));
        }
        if (ArtificeConfig.enderOreGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenCluster(ArtificeBlocks.blockEnderOre, 0, ArtificeConfig.enderOreMinHeight, ArtificeConfig.enderOreMaxHeight, ArtificeConfig.enderOreSize, ArtificeConfig.enderOreFrequency));
        }
        for (i = 0; i < ArtificeConfig.rockNames.length; ++i) {
            if (!ArtificeConfig.rockLayersGen[i]) continue;
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenLayer(ArtificeBlocks.rockBlocks[i], 0, ArtificeConfig.rockLayersMinHeight[i], ArtificeConfig.rockLayersMaxHeight[i]));
        }
        for (i = 0; i < 3; ++i) {
            if (ArtificeConfig.rockClustersGen[i]) {
                WorldHandler.addFeature((IFeatureGenerator)new WorldGenCluster(ArtificeBlocks.rockBlocks[i], 0, ArtificeConfig.rockClustersMinHeight[i], ArtificeConfig.rockClustersMaxHeight[i], ArtificeConfig.rockClustersSize[i], ArtificeConfig.rockClustersFrequency[i]));
            }
            if (!ArtificeConfig.rockCavesGen[i]) continue;
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenCave(ArtificeBlocks.rockBlocks[i], 0, ArtificeConfig.rockCavesMinHeight[i], ArtificeConfig.rockCavesMaxHeight[i], ArtificeConfig.rockCavesSize[i], ArtificeConfig.rockCavesFrequency[i]));
        }
        if (ArtificeConfig.floraWorldGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenFlowers());
        }
        if (ArtificeConfig.lotusWorldGen) {
            WorldHandler.addFeature((IFeatureGenerator)new WorldGenLily());
        }
    }
}

