/*
 * Decompiled with CFR 0.152.
 */
package lumien.extendedpotions.asm;

import lumien.extendedpotions.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"ExtendedPotionsCore");

    public ClassTransformer() {
        this.logger.log(Level.DEBUG, "Starting Class Transformation");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.network.play.server.S1DPacketEntityEffect")) {
            return this.patchEffectPacket(basicClass);
        }
        if (transformedName.equals("net.minecraft.network.play.server.S1EPacketRemoveEntityEffect")) {
            return this.patchRemoveEffectPacket(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.network.NetHandlerPlayClient")) {
            return this.patchClientNetHandlerClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.potion.PotionEffect")) {
            return this.patchPotionEffect(basicClass);
        }
        if (transformedName.equals("net.minecraft.potion.Potion")) {
            return this.patchPotion(basicClass);
        }
        return basicClass;
    }

    private byte[] patchPotionEffect(byte[] basicClass) {
        InsnList toInsert;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found PotionEffect Class: " + classNode.name);
        MethodNode readCustomPotionEffectFromNBT = null;
        MethodNode writeCustomPotionEffectToNBT = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_82722_b"))) {
                readCustomPotionEffectFromNBT = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_82719_a"))) continue;
            writeCustomPotionEffectToNBT = mn;
        }
        if (readCustomPotionEffectFromNBT != null) {
            this.logger.log(Level.DEBUG, " - Found readCustomPotionEffectFromNBT");
            toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/extendedpotions/SavingHandler", "readCustomPotionEffectFromNBT", "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/potion/PotionEffect;", false));
            toInsert.add((AbstractInsnNode)new InsnNode(176));
            readCustomPotionEffectFromNBT.instructions.insert(toInsert);
        }
        if (writeCustomPotionEffectToNBT != null) {
            this.logger.log(Level.DEBUG, " - Found writeCustomPotionEffectToNBT");
            toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/extendedpotions/SavingHandler", "writeCustomPotionEffectToNBT", "(Lnet/minecraft/potion/PotionEffect;Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", false));
            toInsert.add((AbstractInsnNode)new InsnNode(176));
            writeCustomPotionEffectToNBT.instructions.insert(toInsert);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchClientNetHandlerClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found NetHandlerPlayClient Class: " + classNode.name);
        MethodNode handleEffect = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_147260_a"))) continue;
            handleEffect = mn;
        }
        if (handleEffect != null) {
            this.logger.log(Level.DEBUG, " - Found handleEffect");
            for (int i = 0; i < handleEffect.instructions.size(); ++i) {
                AbstractInsnNode ain = handleEffect.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals("net/minecraft/network/play/server/S1DPacketEntityEffect") || !min.name.equals("func_149427_e")) continue;
                this.logger.log(Level.DEBUG, " - Changed handleEffect to refer to proper method");
                min.desc = "()I";
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPotion(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Potion Class: " + classNode.name);
        MethodNode constructor = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals("<init>") || !mn.desc.equals("(IZI)V")) continue;
            constructor = mn;
            break;
        }
        if (constructor != null) {
            for (int i = 0; i < constructor.instructions.size(); ++i) {
                MethodInsnNode min;
                AbstractInsnNode ain = constructor.instructions.get(i);
                if (!(ain instanceof MethodInsnNode) || (min = (MethodInsnNode)ain).getOpcode() != 183 || !min.owner.equals("java/lang/Object") || !min.name.equals("<init>") || !min.desc.equals("()V")) continue;
                this.logger.log(Level.DEBUG, " - Found Constructor");
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 1));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/extendedpotions/ErrorHandler", "checkID", "(Lnet/minecraft/potion/Potion;I)V", false));
                constructor.instructions.insert((AbstractInsnNode)min, toInsert);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEffectPacket(byte[] basicClass) {
        MethodInsnNode newMethod;
        FieldInsnNode fin;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found S1DPacketEntityEffect Class: " + classNode.name);
        for (FieldNode fn : classNode.fields) {
            if (!fn.name.equals("field_149432_b")) continue;
            this.logger.log(Level.DEBUG, " - Changed description of field_149432_b from B to I");
            fn.desc = "I";
        }
        MethodNode constructor = null;
        MethodNode getId = null;
        MethodNode readPacketData = null;
        MethodNode writePacketData = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals("<init>") && mn.desc.equals("(ILnet/minecraft/potion/PotionEffect;)V")) {
                constructor = mn;
                continue;
            }
            if (mn.name.equals("func_149427_e")) {
                getId = mn;
                continue;
            }
            if (mn.name.equals(MCPNames.method("func_148837_a"))) {
                readPacketData = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_148840_b"))) continue;
            writePacketData = mn;
        }
        if (getId != null) {
            this.logger.log(Level.DEBUG, " - Changed getId to Integer");
            getId.desc = "()I";
            for (AbstractInsnNode ain : getId.instructions.toArray()) {
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin2 = (FieldInsnNode)ain;
                fin2.desc = "I";
            }
        }
        if (constructor != null) {
            for (int i = 0; i < constructor.instructions.size(); ++i) {
                AbstractInsnNode ain = constructor.instructions.get(i);
                if (ain instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)ain;
                    if (!min.name.equals(MCPNames.method("func_76456_a"))) continue;
                    this.logger.log(Level.DEBUG, " - Changed Constructor to properly save in field");
                    for (int c = 0; c < 3; ++c) {
                        IntInsnNode n;
                        if (c == 0 && constructor.instructions.get(i + 1) instanceof IntInsnNode && (n = (IntInsnNode)constructor.instructions.get(i + 1)).getOpcode() == 17 && n.operand == 255) {
                            constructor.instructions.remove((AbstractInsnNode)n);
                        }
                        if (c == 1 && constructor.instructions.get(i + 1) instanceof InsnNode && (n = (InsnNode)constructor.instructions.get(i + 1)).getOpcode() == 126) {
                            constructor.instructions.remove((AbstractInsnNode)n);
                        }
                        if (c != 2 || !(constructor.instructions.get(i + 1) instanceof InsnNode) || (n = (InsnNode)constructor.instructions.get(i + 1)).getOpcode() != 145) continue;
                        constructor.instructions.remove((AbstractInsnNode)n);
                    }
                    continue;
                }
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin3 = (FieldInsnNode)ain;
                if (!fin3.name.equals("field_149432_b")) continue;
                fin3.desc = "I";
            }
        }
        if (readPacketData != null) {
            this.logger.log(Level.DEBUG, " - Patching readPacketData");
            for (int i = 0; i < readPacketData.instructions.size(); ++i) {
                AbstractInsnNode ain = readPacketData.instructions.get(i);
                if (ain instanceof FieldInsnNode) {
                    FieldInsnNode fin4 = (FieldInsnNode)ain;
                    if (fin4.name.equals("field_149432_b")) {
                        fin4.desc = "I";
                    }
                }
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals("net/minecraft/network/PacketBuffer") || !min.name.equals("readByte") || !(readPacketData.instructions.get(i + 1) instanceof FieldInsnNode)) continue;
                fin = (FieldInsnNode)readPacketData.instructions.get(i + 1);
                if (!fin.name.equals("field_149432_b")) continue;
                this.logger.log(Level.DEBUG, " - Changed reading to readInt");
                newMethod = new MethodInsnNode(182, "net/minecraft/network/PacketBuffer", "readInt", "()I", false);
                readPacketData.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)newMethod);
                readPacketData.instructions.remove((AbstractInsnNode)min);
            }
        }
        if (writePacketData != null) {
            this.logger.log(Level.DEBUG, " - Patching writePacketData");
            for (int i = 0; i < writePacketData.instructions.size(); ++i) {
                AbstractInsnNode ain = writePacketData.instructions.get(i);
                if (ain instanceof FieldInsnNode) {
                    FieldInsnNode fin5 = (FieldInsnNode)ain;
                    if (fin5.name.equals("field_149432_b")) {
                        fin5.desc = "I";
                    }
                }
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals("net/minecraft/network/PacketBuffer") || !min.name.equals("writeByte") || !(writePacketData.instructions.get(i - 1) instanceof FieldInsnNode)) continue;
                fin = (FieldInsnNode)writePacketData.instructions.get(i - 1);
                if (!fin.name.equals("field_149432_b")) continue;
                this.logger.log(Level.DEBUG, " - Changed writing to writeInt");
                newMethod = new MethodInsnNode(182, "net/minecraft/network/PacketBuffer", "writeInt", "(I)Lio/netty/buffer/ByteBuf;", false);
                writePacketData.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)newMethod);
                writePacketData.instructions.remove((AbstractInsnNode)min);
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchRemoveEffectPacket(byte[] basicClass) {
        MethodInsnNode newMethod;
        FieldInsnNode fin;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found S1EPacketRemoveEntityEffect Class: " + classNode.name);
        MethodNode constructor = null;
        MethodNode getId = null;
        MethodNode readPacketData = null;
        MethodNode writePacketData = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals("<init>") && mn.desc.equals("(ILnet/minecraft/potion/PotionEffect;)V")) {
                constructor = mn;
                continue;
            }
            if (mn.name.equals("func_149075_d")) {
                getId = mn;
                continue;
            }
            if (mn.name.equals(MCPNames.method("func_148837_a"))) {
                readPacketData = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_148840_b"))) continue;
            writePacketData = mn;
        }
        if (getId != null) {
            this.logger.log(Level.DEBUG, " - Changed getId to Integer");
            getId.desc = "()I";
            for (AbstractInsnNode ain : getId.instructions.toArray()) {
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin2 = (FieldInsnNode)ain;
                fin2.desc = "I";
            }
        }
        if (constructor != null) {
            for (int i = 0; i < constructor.instructions.size(); ++i) {
                AbstractInsnNode ain = constructor.instructions.get(i);
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin3 = (FieldInsnNode)ain;
                if (!fin3.name.equals("field_149078_b")) continue;
                fin3.desc = "I";
            }
        }
        if (readPacketData != null) {
            this.logger.log(Level.DEBUG, " - Patching readPacketData");
            for (int i = 0; i < readPacketData.instructions.size(); ++i) {
                AbstractInsnNode ain = readPacketData.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals("net/minecraft/network/PacketBuffer") || !min.name.equals("readUnsignedByte") || !(readPacketData.instructions.get(i + 1) instanceof FieldInsnNode)) continue;
                fin = (FieldInsnNode)readPacketData.instructions.get(i + 1);
                if (!fin.name.equals("field_149078_b")) continue;
                this.logger.log(Level.DEBUG, " - Changed reading to readInt");
                newMethod = new MethodInsnNode(182, "net/minecraft/network/PacketBuffer", "readInt", "()I", false);
                readPacketData.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)newMethod);
                readPacketData.instructions.remove((AbstractInsnNode)min);
            }
        }
        if (writePacketData != null) {
            this.logger.log(Level.DEBUG, " - Patching writePacketData");
            for (int i = 0; i < writePacketData.instructions.size(); ++i) {
                AbstractInsnNode ain = writePacketData.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals("net/minecraft/network/PacketBuffer") || !min.name.equals("writeByte") || !(writePacketData.instructions.get(i - 1) instanceof FieldInsnNode)) continue;
                fin = (FieldInsnNode)writePacketData.instructions.get(i - 1);
                if (!fin.name.equals("field_149078_b")) continue;
                this.logger.log(Level.DEBUG, " - Changed writing to writeInt");
                newMethod = new MethodInsnNode(182, "net/minecraft/network/PacketBuffer", "writeInt", "(I)Lio/netty/buffer/ByteBuf;", false);
                writePacketData.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)newMethod);
                writePacketData.instructions.remove((AbstractInsnNode)min);
            }
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

