/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.api.PipeType;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipePowerDiamond;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerTeleport
extends PipeTeleport<PipeTransportPower>
implements IPipeTransportPowerHook {
    private static final int ICON = 3;

    public PipePowerTeleport(Item item) {
        super(new PipeTransportPower(), item, PipeType.POWER);
        ((PipeTransportPower)this.transport).initFromPipe(PipePowerDiamond.class);
    }

    public int requestEnergy(ForgeDirection from, int value) {
        int requested = 0;
        if ((this.state & 2) == 0) {
            return requested;
        }
        ArrayList<PipePowerTeleport> pipeList = TeleportManager.instance.getConnectedPipes(this, true, false);
        if (pipeList.size() <= 0) {
            return requested;
        }
        for (PipeTeleport pipeTeleport : pipeList) {
            LinkedList<ForgeDirection> possibleMovements = PipePowerTeleport.getRealPossibleMovements(pipeTeleport);
            for (ForgeDirection orientation : possibleMovements) {
                TileEntity tile = pipeTeleport.container.getTile(orientation);
                if (!(tile instanceof TileGenericPipe)) continue;
                TileGenericPipe adjacentTile = (TileGenericPipe)tile;
                PipeTransportPower nearbyTransport = (PipeTransportPower)adjacentTile.pipe.transport;
                nearbyTransport.requestEnergy(orientation.getOpposite(), value);
                requested += nearbyTransport.nextPowerQuery[orientation.getOpposite().ordinal()];
            }
        }
        return requested;
    }

    public int receiveEnergy(ForgeDirection from, int energy) {
        ArrayList<PipePowerTeleport> connectedPipes = TeleportManager.instance.getConnectedPipes(this, false, true);
        LinkedList<PipePowerTeleport> sendingToList = new LinkedList<PipePowerTeleport>();
        if (connectedPipes.size() <= 0 || (this.state & 1) == 0) {
            return 0;
        }
        for (PipePowerTeleport pipe : connectedPipes) {
            if (this.getPipesNeedsPower(pipe).size() <= 0) continue;
            sendingToList.add(pipe);
        }
        if (sendingToList.size() <= 0) {
            return 0;
        }
        double powerToSend = APConfiguration.powerTransmittanceCfg * (float)energy / (float)sendingToList.size();
        for (PipePowerTeleport receiver : sendingToList) {
            List<PowerRequest> needsPower = this.getPipesNeedsPower(receiver);
            if (needsPower.size() <= 0) continue;
            int dividedPowerToSend = MathHelper.func_76143_f((double)(powerToSend / (double)needsPower.size()));
            for (PowerRequest powerEntry : needsPower) {
                PipeTransportPower nearbyTransport = (PipeTransportPower)powerEntry.tile.pipe.transport;
                nearbyTransport.receiveEnergy(powerEntry.orientation, (double)dividedPowerToSend);
            }
        }
        return energy;
    }

    private List<PowerRequest> getPipesNeedsPower(PipePowerTeleport pipe) {
        LinkedList<ForgeDirection> possibleMovements = PipePowerTeleport.getRealPossibleMovements(pipe);
        LinkedList<PowerRequest> needsPower = new LinkedList<PowerRequest>();
        if (possibleMovements.size() > 0) {
            for (ForgeDirection orientation : possibleMovements) {
                TileGenericPipe adjacentPipe;
                TileEntity tile = pipe.container.getTile(orientation);
                if (!(tile instanceof TileGenericPipe) || !PipePowerTeleport.pipeNeedsPower(adjacentPipe = (TileGenericPipe)tile)) continue;
                needsPower.add(new PowerRequest(adjacentPipe, orientation.getOpposite()));
            }
        }
        return needsPower;
    }

    private static boolean pipeNeedsPower(TileGenericPipe tile) {
        if (tile instanceof TileGenericPipe) {
            PipeTransportPower ttb = (PipeTransportPower)tile.pipe.transport;
            for (int i = 0; i < ttb.nextPowerQuery.length; ++i) {
                if (ttb.nextPowerQuery[i] <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static LinkedList<ForgeDirection> getRealPossibleMovements(PipeTeleport<?> pipe) {
        LinkedList<ForgeDirection> result = new LinkedList<ForgeDirection>();
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te;
            if (!pipe.outputOpen(orientation) || !((te = pipe.container.getTile(orientation)) instanceof TileGenericPipe) || !Utils.checkPipesConnections((TileEntity)pipe.container, (TileEntity)te)) continue;
            result.add(orientation);
        }
        return result;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 3;
    }

    private static class PowerRequest {
        public final TileGenericPipe tile;
        public final ForgeDirection orientation;

        public PowerRequest(TileGenericPipe te, ForgeDirection o) {
            this.tile = te;
            this.orientation = o;
        }
    }
}

