/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.planting;

import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import sonar.calculator.mod.integration.planting.IPlanter;
import sonar.calculator.mod.integration.planting.NaturaPlanter;

public class PlanterRegistry {
    public static final IPlanter defaultPlanter = new DefaultPlanter();
    private static Map<String, IPlanter> planters = new THashMap();

    public static void registerPlanters() {
        PlanterRegistry.addPlanter("Natura", new NaturaPlanter());
    }

    public static void addPlanter(String modid, IPlanter planter) {
        planters.put(modid, planter);
    }

    public static IPlanter getPlanter(ItemStack stack) {
        if (stack.func_77973_b() == null || GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()) == null) {
            return defaultPlanter;
        }
        IPlanter planter = planters.get(GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId);
        return planter != null ? planter : defaultPlanter;
    }

    public static class DefaultPlanter
    implements IPlanter {
        @Override
        public Block getCropFromStack(ItemStack stack) {
            if (stack.func_77973_b() instanceof IPlantable) {
                return ((IPlantable)stack.func_77973_b()).getPlant(null, 0, 0, 0);
            }
            return null;
        }

        @Override
        public int getMetaFromStack(ItemStack stack) {
            if (stack.func_77973_b() instanceof IPlantable) {
                return ((IPlantable)stack.func_77973_b()).getPlantMetadata(null, 0, 0, 0);
            }
            return 0;
        }
    }
}

