/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.nei.handlers;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.calculators.GuiCalculator;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RecipeHelper;

public class CalculatorRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(100, 25, 22, 14), "calculator", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCalculator.class;
    }

    public String getRecipeName() {
        return FontHelper.translate((String)"item.Calculator.name");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("calculator") && ((Object)((Object)this)).getClass() == CalculatorRecipeHandler.class) {
            Map recipes = RecipeRegistry.CalculatorRecipes.instance().getRecipes();
            for (Map.Entry recipe : recipes.entrySet()) {
                if (!CalculatorConfig.isEnabled((ItemStack)((Object[])recipe.getValue())[0])) continue;
                this.arecipes.add(new SmeltingPair(((Object[])recipe.getKey())[0], ((Object[])recipe.getKey())[1], ((Object[])recipe.getValue())[0]));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!CalculatorConfig.isEnabled(result)) {
            return;
        }
        Map recipes = RecipeRegistry.CalculatorRecipes.instance().getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)((Object[])recipe.getValue())[0]), (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair(((Object[])recipe.getKey())[0], ((Object[])recipe.getKey())[1], ((Object[])recipe.getValue())[0]));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("calculator") && ((Object)((Object)this)).getClass() == CalculatorRecipeHandler.class) {
            this.loadCraftingRecipes("calculator", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = RecipeRegistry.CalculatorRecipes.instance().getRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (RecipeRegistry.CalculatorRecipes.instance().containsStack(ingredient, (Object[])recipe.getKey(), false) == -1) continue;
            this.arecipes.add(new SmeltingPair(((Object[])recipe.getKey())[0], ((Object[])recipe.getKey())[1], ((Object[])recipe.getValue())[0]));
        }
    }

    public String getGuiTexture() {
        return "Calculator:textures/gui/calculator.png";
    }

    public String getOverlayIdentifier() {
        return "calculator";
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack input2;
        PositionedStack output;

        public SmeltingPair(Object input, Object input2, Object output) {
            super((TemplateRecipeHandler)CalculatorRecipeHandler.this);
            if (input instanceof RecipeHelper.OreStack) {
                input = ((RecipeHelper.OreStack)input).getStacks();
            }
            if (input2 instanceof RecipeHelper.OreStack) {
                input2 = ((RecipeHelper.OreStack)input2).getStacks();
            }
            this.input = new PositionedStack(input, 20, 24);
            this.input2 = new PositionedStack(input2, 74, 24);
            this.output = new PositionedStack(output, 129, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CalculatorRecipeHandler.this.cycleticks / 16, Arrays.asList(this.input, this.input2));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

